<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="2.0" encoding="iso-8859-1" indent="yes"/>
	<xsl:template match="/">
		<html xsl:version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
			<head>
				<title>Rapport</title>
				<meta http-equiv="imagetoolbar" content="no"/>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
				<style type="text/css">

table.detailedTable {
	border-width: 1px 1px 1px 1px;
	padding: 1px 1px 1px 1px;
	border-style: solid solid solid solid;
	border-color: black black black black;
	border-collapse: collapse;
	background-color: white;
}
td.detailedTable {
	border-width: 1px 1px 1px 1px;

}

table {
	border-collapse: collapse;
	background-color: white;
}
table th {
	border-width: 0px 0px 0px 0px;
	padding: 1px 1px 1px 1px;
	border-style: solid solid solid solid;
	border-color: black black black black;
	background-color: white;
	-moz-border-radius: 0px 0px 0px 0px;
}
table td {
	border-width: 0px 0px 0px 0px;
	padding: 1px 1px 1px 1px;
	border-style: solid solid solid solid;
	border-color: black black black black;
	-moz-border-radius: 0px 0px 0px 0px;
}
				BODY, TABLE, TR, TD, P {font-family: arial, verdana, sans-serif; font-size: 11px; font-weight: normal;}
				</style>
			</head>
			<body>
				<xsl:for-each select="batch">
					<table border="1" width="3700" cellspacing="5" cellpadding="5">
						<tr>
							<td>
								<TABLE id="Table1" class="detailedTable" cellSpacing="1" cellPadding="1" width="100%" border="0">
									<TR>
										<TD colspan="19">
											<STRONG>
												<FONT size="19">Rapport/validera din bgcInvoice fil</FONT>
												<br/>
											</STRONG>
										</TD>
									</TR>
									<tr>
										<td colspan="19">
											<HR width="100%" SIZE="1"/>
										</td>
									</tr>
									<tr>
										<td colspan="4">
											<STRONG>
												<font size="1">Version av filter</font>
											</STRONG>
										</td>
										<td colspan="19">
											<font size="1">2012-12-14</font>
										</td>
									</tr>
									<tr>
										<td colspan="19">
											<STRONG>
												<font size="1">Instruktion per färgkod</font>
											</STRONG>
										</td>
									</tr>
									<tr>
										<td colspan="3">
											<xsl:attribute name="bgcolor">#FF7F50</xsl:attribute>
										</td>
										<td/>
										<td colspan="19">
											<STRONG>
												<font size="1">Varning. Alla kontroller är okej förutom e-adressen som bör vara 13 (EAN) eller 12 tecken (SE+orgnr).</font>
											</STRONG>
										</td>
									</tr>
									<tr>
										<td colspan="3">
											<xsl:attribute name="bgcolor">#009900</xsl:attribute>
										</td>
										<td/>
										<td colspan="19">
											<STRONG>
												<font size="1">OK. Alla kontroller är uppfyllda</font>
											</STRONG>
										</td>
									</tr>
									<tr>
										<td colspan="3">
											<xsl:attribute name="bgcolor">#FFFF00</xsl:attribute>
										</td>
										<td/>
										<td colspan="19">
											<STRONG>
												<font size="1">Kanalen används ej utifrån instruktion i fakturan</font>
											</STRONG>
										</td>
									</tr>
									<tr>
										<td colspan="3">
											<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
										</td>
										<td/>
										<td colspan="19">
											<STRONG>
												<font size="1">FEL. En eller flera regler är ej uppfyllda. Se kommentar.</font>
											</STRONG>
										</td>
									</tr>
									<tr>
										<td colspan="19">
											<HR width="100%" SIZE="1"/>
										</td>
									</tr>
									<TR>
										<td colspan="3">
											<STRONG>
												<font size="1">Fil status&#160;</font>
											</STRONG>
										</td>
										<td/>
										<td colspan="18">
											<STRONG>
												<font size="1">
													<xsl:if test="/batch/@status='P'">
														<b>Produktion</b>
													</xsl:if>
													<xsl:if test="/batch/@status='T'">
														<b>Test</b>
													</xsl:if>
													<xsl:if test="/batch/@status='C'">
														<b>Certifiering</b>
													</xsl:if>
												</font>
											</STRONG>
										</td>
									</TR>
									<TR>
										<td colspan="3">
											<STRONG>
												<font size="1">Fil bgnr&#160;</font>
											</STRONG>
										</td>
										<td/>
										<td colspan="18">
											<STRONG>
												<font size="1">
													<xsl:call-template name="show-gironr">
														<xsl:with-param name="gironr" select="/batch/batchDetails/bgnr"/>
													</xsl:call-template>
												</font>
											</STRONG>
										</td>
									</TR>
									<TR>
										<td colspan="3">
											<STRONG>
												<font size="1">Antal avsnitt i filen&#160;</font>
											</STRONG>
										</td>
										<td/>
										<td colspan="18">
											<STRONG>
												<font size="1">
													<xsl:call-template name="show-number">
														<xsl:with-param name="number" select="/batch/batchDetails/totalSections"/>
													</xsl:call-template>&#160;st
												</font>
											</STRONG>
										</td>
									</TR>
									<TR>
										<td colspan="3">
											<STRONG>
												<font size="1">Antal dokument i filen&#160;</font>
											</STRONG>
										</td>
										<td/>
										<td colspan="18">
											<STRONG>
												<font size="1">
													<xsl:call-template name="show-number">
														<xsl:with-param name="number" select="/batch/batchDetails/totalDocuments"/>
													</xsl:call-template>&#160;st
												</font>
											</STRONG>
										</td>
									</TR>
									<tr>
										<td colspan="3">
											<STRONG>
												<font size="1">Antal avsnitt i filen</font>
											</STRONG>
										</td>
										<td/>
										<td>
											<xsl:choose>
												<xsl:when test="/batch/batchDetails/totalSections!=count(/batch/section)">
													<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="bgcolor">#009900</xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
									<tr>
										<td colspan="3">
											<STRONG>
												<font size="1">Kommentar</font>
											</STRONG>
										</td>
										<td/>
										<td colspan="19">
											<xsl:if test="/batch/batchDetails/totalSections!=count(/batch/section)">Antal avsnitt i (/batch/batchDetails/totalSections) överensstämmer ej med räknat antal avsnitt.<br/>
												<xsl:value-of select="/batch/batchDetails/totalSections"/>;<xsl:value-of select="count(/batch/section)"/>
											</xsl:if>
										</td>
									</tr>
									<tr>
										<td colspan="3">
											<STRONG>
												<font size="1">Antal dokument i filen</font>
											</STRONG>
										</td>
										<td/>
										<td>
											<xsl:choose>
												<xsl:when test="/batch/batchDetails/totalDocuments!=count(/batch/section/document)">
													<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
												</xsl:when>
												<xsl:when test="sum(/batch/section/sectionDetails/totalDocuments)!=count(/batch/section/document)">
													<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="bgcolor">#009900</xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
									<tr>
										<td colspan="3">
											<STRONG>
												<font size="1">Kommentar</font>
											</STRONG>
										</td>
										<td/>
										<td colspan="19">
											<xsl:if test="/batch/batchDetails/totalDocuments!=count(/batch/section/document)">Antal dokument i (/batch/batchDetails/totalDocuments) överensstämmer ej med räknat antal dokument.<br/>
											</xsl:if>
											<xsl:if test="sum(/batch/section/sectionDetails/totalDocuments)!=count(/batch/section/document)">Antal summerade dokument i (/batch/section/sectionDetails/totalDocuments) överensstämmer ej med räknat antal dokument.<br/>
											</xsl:if>
										</td>
									</tr>
									<TR>
										<td colspan="3">
											<STRONG>
												<font size="1">Beloppssumma i filen&#160;</font>
											</STRONG>
										</td>
										<td/>
										<td colspan="18">
											<STRONG>
												<font size="1">
													<xsl:call-template name="show-amount">
														<xsl:with-param name="amount" select="sum(/batch/section/document/invoice/invoiceDetails/invoiceTotal/totalAmount)"/>
													</xsl:call-template>
												</font>
											</STRONG>
										</td>
									</TR>
									<xsl:variable name="numberOfDocuments">
										<xsl:value-of select="/batch/batchDetails/totalDocuments"/>
									</xsl:variable>
									<xsl:variable name="numberOfPrintInfo">
										<xsl:value-of select="count(/batch/section/document/invoice/printInfo/@id)"/>
									</xsl:variable>
									<xsl:variable name="numberOfUniquePrint">
										<xsl:value-of select="count(/batch/section/document/invoice/printInfo)"/>
									</xsl:variable>
									<xsl:variable name="numberOfUniquePrintInfo">
										<xsl:value-of select="count(/batch/section/document/invoice/printInfo/@id[not(.=preceding::printInfo/@id)])"/>
									</xsl:variable>
									<xsl:variable name="numberOfUniqueOriginatorBgnr">
										<xsl:value-of select="count(/batch/section/document/documentDetails/originatorBgnr[not(.=preceding::originatorBgnr)])"/>
									</xsl:variable>
									<xsl:variable name="numberOfUniqueSellerId">
										<xsl:value-of select="count(/batch/section/document/invoice/seller/@id[not(.=preceding::seller/@id)])"/>
									</xsl:variable>
									<xsl:variable name="numberOfUniquePrintInfoIdNumeric">
										<xsl:choose>
											<xsl:when test="string(number(/batch/section/document/invoice/seller/@id))!='NaN'">true</xsl:when>
											<xsl:otherwise>false</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:variable name="numberOfZeroNumberOfDocument">
										<xsl:value-of select="count(/batch/batchDetails/totalSections[substring(.,1,1)='0']) + count(/batch/batchDetails/totalDocuments[substring(.,1,1)='0']) + count(/batch/section/sectionDetails/totalDocuments[substring(.,1,1)='0'])"/>
									</xsl:variable>
									<TR>
										<td colspan="3">
											<STRONG>
												<font size="1">E-print instruktion&#160;</font>
											</STRONG>
										</td>
										<td/>
										<td colspan="18">
											<xsl:choose>
												<xsl:when test="$numberOfUniquePrint=$numberOfDocuments">
													<STRONG>
														<font size="1">Ja</font>
													</STRONG>
												</xsl:when>
												<xsl:when test="$numberOfUniquePrint!=$numberOfDocuments">
													<STRONG>
														<font size="1"> Nej</font>
													</STRONG>
												</xsl:when>
											</xsl:choose>
										</td>
									</TR>
									<TR>
										<td colspan="3">
											<STRONG>
												<font size="1">E-print återredovisning sker till&#160;</font>
											</STRONG>
										</td>
										<td/>
										<td colspan="18">
											<STRONG>
												<xsl:choose>
													<xsl:when test="$numberOfUniquePrint!=$numberOfDocuments">
														<font size="1">OBS! Print objekt saknas i filen. Kontrollera dina fakturor och inställning i programmet.</font>
													</xsl:when>
													<xsl:when test="$numberOfUniquePrintInfo='1' and $numberOfPrintInfo=$numberOfDocuments">
														<font size="1">
															<xsl:value-of select="/batch/section/document/invoice/printInfo/@id[1]"/>
														</font>
													</xsl:when>
													<xsl:when test="$numberOfUniqueOriginatorBgnr='1' and $numberOfUniqueSellerId='1'">
														<font size="1">
															<xsl:value-of select="/batch/section/document/invoice/seller/@id[1]"/>
														</font>
													</xsl:when>
													<xsl:when test="$numberOfUniquePrintInfo!='1' and $numberOfUniqueOriginatorBgnr='1'">
														<font size="1" color="red">FEL: </font>
														<font size="1">Ett bolag (avtalsbgnr) skickar filen men olika bolag (orgnr) får print kvittot. Kontrollera dina fakturor och inställning i programmet.</font>
													</xsl:when>
													<xsl:when test="$numberOfUniquePrintInfo!='1'">
														<font size="1" color="red">VARNING: </font>
														<font size="1">Ett bolag (avtalsbgnr) skickar filen men olika bolag får print kvittot (orgnr saknas i printInfo/@id).</font>
													</xsl:when>
													<xsl:otherwise>
														<font size="1" color="red">VARNING:</font>
														<font size="1">Ett bolag (avtalsbgnr) skickar filen men olika bolag får print kvittot (orgnr saknas i printInfo/@id).</font>
													</xsl:otherwise>
												</xsl:choose>
											</STRONG>
										</td>
									</TR>
									<tr>
										<td colspan="3">
											<STRONG>
												<font size="1">E-print återredovisning</font>
											</STRONG>
										</td>
										<td/>
										<td>
											<xsl:choose>
												<xsl:when test="($numberOfUniquePrintInfo!='1' and $numberOfUniquePrintInfo!='0') and $numberOfUniqueOriginatorBgnr='1'">
													<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
												</xsl:when>
												<xsl:when test="substring(/batch/section/document/invoice/printInfo/@id[1],1,2)='00'">
													<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
												</xsl:when>
												<xsl:when test="$numberOfUniquePrintInfo=1 and $numberOfPrintInfo=$numberOfDocuments">
													<xsl:attribute name="bgcolor">#009900</xsl:attribute>
												</xsl:when>
												<xsl:when test="$numberOfUniquePrint &gt; 0">
													<xsl:attribute name="bgcolor">#009900</xsl:attribute>
												</xsl:when>
												<xsl:when test="$numberOfUniquePrint!=$numberOfDocuments">
													<xsl:attribute name="bgcolor">#FFFF00</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
									<tr>
										<td colspan="3">
											<STRONG>
												<font size="1">Kommentar</font>
											</STRONG>
										</td>
										<td/>
										<td colspan="19">
											<xsl:if test="($numberOfUniquePrintInfo!='1' and $numberOfUniquePrintInfo!='0') and $numberOfUniqueOriginatorBgnr='1'">Det finns olika orgnr i (printInfo/@id)<br/>
											</xsl:if>
											<xsl:if test="$numberOfUniquePrint!=$numberOfDocuments">Det saknas printInfo objekt i vissa fakturor (antal printInfo jmf med totalDocuments)<br/>
											</xsl:if>
											<xsl:if test="substring(/batch/section/document/invoice/printInfo/@id[1],1,2)='00'">Orgnr i printInfo/@id verkar ej vara korrekt. Inleds med 00<br/>
											</xsl:if>
											<xsl:if test="$numberOfUniquePrint = 0">PrintInfo objekt saknas i filen<br/>
											</xsl:if>
											<xsl:if test="$numberOfUniquePrintInfoIdNumeric ='false'">Varning! Orgnr i printInfo/@id ej numeriskt. Innehåller bindestreck<br/>
											</xsl:if>
										</td>
									</tr>
									<tr>
										<td colspan="3" valign="top">
											<STRONG>
												<font size="1">Elementet antal dokument<br/>är numeriskt (inleds ej med 0)</font>
											</STRONG>
										</td>
										<td/>
										<td>
											<xsl:choose>
												<xsl:when test="$numberOfZeroNumberOfDocument=0">
													<xsl:attribute name="bgcolor">#009900</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
									<xsl:for-each select="section">
										<tr>
											<td colspan="19">
												<HR width="100%" SIZE="1"/>
											</td>
										</tr>
										<TR>
											<td colspan="3">
												<STRONG>
													<font size="1">Avsnitts id&#160;</font>
												</STRONG>
											</td>
											<td/>
											<td colspan="18">
												<STRONG>
													<font size="1">
														<xsl:value-of select="./@id"/>
													</font>
												</STRONG>
											</td>
										</TR>
										<TR>
											<TR>
												<td colspan="3">
													<STRONG>
														<font size="1">Fil bgnr&#160;</font>
													</STRONG>
												</td>
												<td/>
												<td colspan="18">
													<STRONG>
														<font size="1">
															<xsl:call-template name="show-gironr">
																<xsl:with-param name="gironr" select="./@bgnr"/>
															</xsl:call-template>
														</font>
													</STRONG>
												</td>
											</TR>
										</TR>
										<TR>
											<td colspan="3">
												<STRONG>
													<font size="1">Antal dokument i avsnittet&#160;</font>
												</STRONG>
											</td>
											<td/>
											<td colspan="18">
												<STRONG>
													<font size="1">
														<xsl:call-template name="show-number">
															<xsl:with-param name="number" select="./sectionDetails/totalDocuments"/>
														</xsl:call-template>&#160;st
												</font>
												</STRONG>
											</td>
										</TR>
										<tr>
											<td colspan="19">
											</td>
										</tr>
										<tr>
											<th colspan=""/>
											<th colspan="11">Kontroller/regelverk per kanal</th>
											<th colspan="26">Innehåll i filen</th>
										</tr>
										<TR>
											<td colspan="1">Rad</td>
											<td>Fakturanr</td>
											<td>Bas</td>
											<td>E-print</td>
											<td>E-privat</td>
											<td>E-företag</td>
											<td>Via Nordea</td>
											<td>Via Swedbank</td>
											<td>Svefaktura</td>
											<td>Total s:a</td>
											<td>Rad s:a</td>
											<td/>
											<td>Kommentar</td>
											<td>Rad</td>
											<td>Företag</td>
											<td>Organisationsnr</td>
											<td>Avtals bgnr</td>
											<td>Typ</td>
											<td>Kod</td>
											<td>Fakturadatum</td>
											<td>Förfallodatum</td>
											<td>OCR</td>
											<td align="right">Netto</td>
											<td align="right">Moms</td>
											<td align="right">Total</td>
											<td>Valuta</td>
											<td>Inbetalningsbgnr</td>
											<td>Betalas via</td>
											<td>Distribution</td>
											<td>Print layout</td>
											<td>Porto</td>
											<td>E-adress</td>
											<td>Kundnr</td>
											<td>Namn</td>
											<td>Enhet</td>
											<td>Adress</td>
											<td>Postnr</td>
											<td>Postort</td>
											<td>Landskod</td>
											<td>Land</td>
											<td>Er referens</td>
											<td>Projektnr</td>
											<td>Organisationsnr</td>
											<td>EAN/gs1</td>
										</TR>
										<xsl:for-each select="document">
											<TR>
												<xsl:if test="position() mod 2 = 0">
													<xsl:attribute name="bgcolor">#E6E6FA</xsl:attribute>
												</xsl:if>
												<td colspan="1">
													<xsl:value-of select="position()"/>
												</td>
												<td>
													<xsl:value-of select='translate(invoice/invoiceDetails/invoiceNumber, "", "")'/>
												</td>
												<xsl:variable name="buyer_SellerId">
													<xsl:value-of select="invoice/buyer/@sellerID"/>
												</xsl:variable>
												<xsl:variable name="boolSellerGS1">
													<xsl:choose>
														<xsl:when test="string(number(invoice/seller/gs1))!='NaN'">true</xsl:when>
														<xsl:when test="invoice/seller/gs1=''">true</xsl:when>
														<xsl:when test="not(invoice/seller/gs1)">true</xsl:when>
														<xsl:when test="string(number(invoice/seller/gs1))='NaN'">false</xsl:when>
														<xsl:otherwise>true</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolBuyerGS1">
													<xsl:choose>
														<xsl:when test="string(number(invoice/buyer/gs1))!='NaN'">true</xsl:when>
														<xsl:when test="invoice/buyer/gs1=''">true</xsl:when>
														<xsl:when test="not(invoice/buyer/gs1)">true</xsl:when>
														<xsl:when test="string(number(invoice/buyer/gs1))='NaN'">false</xsl:when>
														<xsl:otherwise>true</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolVatDetails">
													<xsl:choose>
														<xsl:when test="invoice/invoiceDetails/vatAmount!=''">
															<xsl:if test="count(invoice/invoiceDetails/vatAmount) = count(invoice/invoiceDetails/vatAmount/@rate[.!='']) and count(invoice/invoiceDetails/vatAmount) = count(invoice/invoiceDetails/vatAmount/@base[.!=''])">true</xsl:if>
														</xsl:when>
														<xsl:when test="invoice/invoiceDetails/vatAmount='' or not(invoice/invoiceDetails/vatAmount)">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolInvoiceIdB2B">
													<xsl:choose>
														<xsl:when test="./@id = invoice/@id and invoice/@id = invoice/invoiceDetails/invoiceNumber">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolInvoiceIdB2C">
													<xsl:choose>
														<xsl:when test="invoice/invoiceDetails/identifier[@type='OCR'] !='' or invoice/invoiceDetails/identifier[@type='MED'] !=''">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolSumRowNetAmount">
													<xsl:choose>
														<xsl:when test="round(sum(invoice/invoiceRow/netAmount) * 100) + round(sum(invoice/invoiceDetails/expenses/netAmount) * 100)+ round(sum(invoice/invoiceDetails/freightDetails/freightAmount) * 100) = round(sum(invoice/invoiceDetails/invoiceTotal/netAmount) * 100)">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>												
												<xsl:variable name="boolPaymentInstructions">
													<xsl:choose>
														<xsl:when test="invoice/invoiceDetails/identifier!='' and invoice/epiDetails/paymentInstructions/remittanceID != invoice/invoiceDetails/identifier">false</xsl:when>
														<xsl:when test="invoice/invoiceDetails/identifier!='' and invoice/epiDetails/paymentInstructions/remittanceID = invoice/invoiceDetails/identifier">true</xsl:when>
														<xsl:when test="(invoice/invoiceDetails/identifier='' or not(invoice/invoiceDetails/identifier)) and invoice/epiDetails/paymentInstructions/remittanceID != ''">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="countBankgiroNumber">
													<xsl:value-of select="count(invoice/seller/accounts/account[./@type='BG'])"/>
												</xsl:variable>									
												<xsl:variable name="boolBuyerPostCode">
													<xsl:choose>
														<xsl:when test="(invoice/buyer/postalAddress/country/@code='SE' or invoice/buyer/postalAddress/country/@code='' or not(invoice/buyer/postalAddress/country/@code)) and string(number(translate(invoice/buyer/postalAddress/town/@postCode, ' ', '')))='NaN'">false</xsl:when>
														<xsl:otherwise>true</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolTotalAmountCredit">
													<xsl:choose>
														<xsl:when test="invoice/invoiceDetails/invoiceTotal/totalAmount &lt; 0 and ./@distribution='B2C'">false</xsl:when>
														<xsl:otherwise>true</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolGenerellt">
													<xsl:choose>
														<xsl:when test="($boolBuyerPostCode='true') and /batch/@id='' and ((substring(/batch/batchDetails/bgnr,1,2)='00' and /batch/batchDetails/bgnr!='' and substring(/batch/section/@bgnr,1,2)='00' and /batch/section/@bgnr!='' and substring(/batch/section/document/documentDetails/originatorBgnr[1],1,2)='00' and /batch/section/document/documentDetails/originatorBgnr!='') or (/batch/batchDetails/originatorID!='' and /batch/section/@originatorID!='' and /batch/section/document/documentDetails/originatorID!='')) and invoice/invoiceDetails/invoiceType!='' and invoice/invoiceDetails/invoiceNumber!='' and invoice/invoiceDetails/invoiceDate!='' and invoice/invoiceDetails/invoiceTotal/totalAmount!='' and invoice/seller/@id!='' and invoice/seller/name!='' and invoice/seller/postalAddress/name!='' and invoice/seller/postalAddress/town!='' and invoice/seller/postalAddress/town/@postCode!='' and invoice/buyer/postalAddress/name!='' and invoice/buyer/postalAddress/town!='' and invoice/buyer/postalAddress/town/@postCode!='' and invoice/payment/dueDate!='' and invoice/payment/totalAmount!='' and invoice/seller/accounts/account!='' and invoice/buyer/postalAddress/name=invoice/buyer/name and invoice/seller/postalAddress/name=invoice/seller/name and not(contains(invoice/seller/vatDetails/vatNumber, '-')) and not(contains(invoice/seller/accounts/account, '-')) and (invoice/seller/accounts/account/@type='BG' or invoice/seller/accounts/account/@type='BGABSESS') and (./@distribution='B2B' or ./@distribution='B2C') and ./@templateID='1' and (./@originPaper='false' or not(./@originPaper)) and (invoice/seller/mainContact/phone != invoice/seller/mainContact/fax or invoice/seller/mainContact/phone='' or invoice/seller/mainContact/fax='' or not(invoice/seller/mainContact/phone) or not(invoice/seller/mainContact/fax)) and (10=string-length(string(invoice/seller/@id)) or 11=string-length(string(invoice/seller/@id)))  and invoice/payment/dueDate=invoice/epiDetails/paymentInstructions/optionDate and $boolVatDetails='true' and $boolPaymentInstructions='true' and (invoice/invoiceDetails/invoiceNumber=./@id or invoice/invoiceDetails/identifier=./@id)">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolPrintImage">
													<xsl:choose>
														<xsl:when test="(invoice/printInfo/imageBase64/data='' or not(invoice/printInfo/imageBase64/data)) and (invoice/printInfo/imageBase64/@width='' or not(invoice/printInfo/imageBase64/@width)) and (invoice/printInfo/imageBase64/@height='' or not(invoice/printInfo/imageBase64/@height))">true</xsl:when>
														<xsl:when test="invoice/printInfo/imageBase64/data!='' and (invoice/printInfo/imageBase64/@width='' or not(invoice/printInfo/imageBase64/@width)) and (invoice/printInfo/imageBase64/@height='' or not(invoice/printInfo/imageBase64/@height))">false</xsl:when>
														<xsl:when test="invoice/printInfo/imageBase64/data!='' and invoice/printInfo/imageBase64/@width&lt;286 and invoice/printInfo/imageBase64/@height&lt;86">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolPrint">
													<xsl:choose>
														<xsl:when test="$boolPrintImage='true' and (invoice/printInfo/languageCode='SE' or invoice/printInfo/languageCode='EN') and (invoice/printInfo/postage='A' or invoice/printInfo/postage='B') and (invoice/printInfo/layout='B2C01' or invoice/printInfo/layout='B2C02' or invoice/printInfo/layout='B2B01' or invoice/printInfo/layout='B2B02') and invoice/buyer/postalAddress/name!='' and invoice/buyer/postalAddress/town/@postCode!='' and invoice/buyer/postalAddress/town!='' and invoice/seller/postalAddress/name!='' and (invoice/seller/postalAddress/street!='' or invoice/seller/postalAddress/postOfficeBox!='') and invoice/seller/postalAddress/town!='' and invoice/seller/postalAddress/town/@postCode!='' and not(contains($buyer_SellerId, '------')) and not(contains($buyer_SellerId, '_____')) and not(contains($buyer_SellerId, '0000000000')) and $buyer_SellerId!='' and $boolGenerellt!='false' and (invoice/invoiceDetails/invoiceTotal/vatAmount!='' or count(invoice/invoiceDetails/vatAmount) &gt; 0 or contains(invoice/invoiceDetails/invoiceType,'avi') or contains(invoice/invoiceDetails/invoiceType,'AVI')) and (((invoice/printInfo/layout='B2C01' or invoice/printInfo/layout='B2C02') and count(invoice/invoiceRow/totalAmount) &gt; 0) or ((invoice/printInfo/layout='B2B01' or invoice/printInfo/layout='B2B02') and count(invoice/invoiceRow/netAmount) &gt; 0)) and ($boolInvoiceIdB2B='true' or $boolInvoiceIdB2C='true') and $countBankgiroNumber!=0">true</xsl:when>
														<xsl:when test="not(invoice/printInfo)"/>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolPrivat">
													<xsl:choose>
														<xsl:when test="./@distribution!='B2C'"/>
														<xsl:when test="./@distribution='B2B'"/>
														<xsl:when test="./@distribution='B2C' and invoice/buyer/bankCustomer/identifier[@type='BE']='' and (invoice/buyer/bankCustomer/invoiceReference/date='' or not(invoice/buyer/bankCustomer/invoiceReference/date='')) and (invoice/buyer/bankCustomer/invoiceReference/@id='' or not(invoice/buyer/bankCustomer/invoiceReference/@id='')) and (invoice/payment/method/@code='EG' or invoice/payment/method/@code='EA')"/>
														<xsl:when test="./@distribution='B2C' and invoice/buyer/bankCustomer/identifier[@type='BE']!='' and substring(invoice/buyer/bankCustomer/identifier[@type='BE'],1,4)!='0000' and 16=string-length(string(invoice/buyer/bankCustomer/identifier[@type='BE'])) and invoice/buyer/bankCustomer/invoiceReference/date!='' and invoice/payment/dueDate!='' and invoice/buyer/bankCustomer/invoiceReference/@id!='' and (invoice/invoiceDetails/identifier[@type='OCR']!='' or invoice/invoiceDetails/identifier[@type='MED']!='') and invoice/invoiceDetails/invoiceTotal/totalAmount!='' and ./invoice/invoiceDetails/identifier=invoice/buyer/bankCustomer/invoiceReference/@id and (invoice/payment/method/@code='EG' or invoice/payment/method/@code='EA') and string(number(invoice/buyer/bankCustomer/invoiceReference/@id))!='NaN' and $boolGenerellt!='false' and $boolTotalAmountCredit='true' and $boolInvoiceIdB2C='true' and invoice/payment/dueDate=invoice/buyer/bankCustomer/invoiceReference/date">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolForetag">
													<xsl:choose>
														<xsl:when test="./@distribution='B2C'"/>
														<xsl:when test="./@distribution='B2B' and (./documentDetails/addresseeID='' or not(./documentDetails/addresseeID))"/>
														<xsl:when test="./@distribution='B2B' and count(invoice/invoiceRow/netAmount[.!=''])=count(invoice/invoiceRow/netAmount) and ./documentDetails/addresseeID!='' and ((invoice/buyer/contact/name!='' and invoice/buyer/contact/text!='') or invoice/invoiceDetails/projectReference/@id!='') and count(invoice/invoiceRow[(article/@id='' and article/name='')]) = 0  and invoice/epiDetails/beneficiary/account!='' and invoice/epiDetails/paymentInstructions/remittanceID!='' and count(invoice/epiDetails/paymentInstructions/remittanceID) &gt; 0 and invoice/epiDetails/paymentInstructions/instructedAmount!='' and invoice/epiDetails/paymentInstructions/optionDate!='' and invoice/invoiceDetails/invoiceType!='' and invoice/invoiceDetails/invoiceNumber!='' and invoice/invoiceDetails/invoiceDate!='' and invoice/invoiceDetails/invoiceTotal/totalAmount!='' and invoice/seller/@id!='' and invoice/seller/name!='' and invoice/seller/vatDetails/vatNumber!='' and invoice/seller/postalAddress/name!='' and invoice/seller/postalAddress/town!='' and invoice/seller/postalAddress/town/@postCode!='' and invoice/buyer/postalAddress/name!='' and invoice/buyer/postalAddress/town!='' and invoice/buyer/postalAddress/town/@postCode!='' and invoice/payment/dueDate!='' and invoice/payment/totalAmount!='' and invoice/seller/accounts/account!='' and count(invoice/invoiceDetails/vatAmount) &gt; 0 and invoice/invoiceDetails/invoiceTotal/vatAmount!='' and invoice/invoiceDetails/invoiceTotal/netAmount!='' and $boolGenerellt='true' and $boolBuyerGS1='true' and $boolSellerGS1='true' and count(invoice/invoiceRow/netAmount) &gt; 0 and not(contains(documentDetails/addresseeID, '-')) and invoice/invoiceDetails/vatAmount/@base!='' and invoice/invoiceDetails/vatAmount/@rate!='' and $boolInvoiceIdB2B='true' and count(invoice/invoiceRow/article/name[.!=''])!=0 and $boolSumRowNetAmount='true'">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolSvefaktura">
													<xsl:choose>
														<xsl:when test="./@distribution='B2C'"/>
														<xsl:when test="./@distribution='B2B' and (./documentDetails/addresseeID='' or not(./documentDetails/addresseeID))"/>
														<xsl:when test="./@distribution='B2B' and count(invoice/invoiceRow/netAmount[.!=''])=count(invoice/invoiceRow/netAmount) and count(invoice/invoiceRow)=count(invoice/invoiceRow/netAmount) and count(invoice/invoiceRow[(article/@id='' and article/name='')]) = 0  and ./documentDetails/addresseeID!='' and ((invoice/buyer/contact/name!='' and invoice/buyer/contact/text!='') or invoice/invoiceDetails/projectReference/@id!='') and invoice/epiDetails/beneficiary/account!='' and invoice/epiDetails/paymentInstructions/remittanceID!='' and invoice/epiDetails/paymentInstructions/instructedAmount!='' and invoice/epiDetails/paymentInstructions/optionDate!='' and count(invoice/invoiceDetails/vatAmount) &gt; 0 and invoice/invoiceDetails/invoiceTotal/vatAmount!='' and invoice/invoiceDetails/invoiceTotal/netAmount!='' and (substring(invoice/buyer/@id,1,2)='00' or substring(invoice/buyer/@id,1,1)='5' or substring(invoice/buyer/@id,1,1)='2' or substring(invoice/buyer/@id,1,2)='21' or invoice/buyer/@id='' or not(invoice/buyer/@id)) and $boolForetag='true'">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolSvefakturaAdress">
													<xsl:choose>
														<xsl:when test="$boolSvefaktura='true' and (substring(./documentDetails/addresseeID,1,2)='SE' or substring(./documentDetails/addresseeID,1,2)='73'  or substring(./documentDetails/addresseeID,1,2)='00'  or substring(./documentDetails/addresseeID,1,2)='55'  or substring(./documentDetails/addresseeID,1,2)='21'  or substring(./documentDetails/addresseeID,1,2)='20') and (10=string-length(./documentDetails/addresseeID) or 12=string-length(./documentDetails/addresseeID) or 13=string-length(./documentDetails/addresseeID) or 16=string-length(./documentDetails/addresseeID))">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolNordea">
													<xsl:choose>
														<xsl:when test="./@distribution='B2C'"/>
														<xsl:when test="./@distribution='B2B' and (./documentDetails/addresseeID='' or not(./documentDetails/addresseeID) or ./documentDetails/addresseeIntermediator!='NDEASESS' or not(./documentDetails/addresseeIntermediator) or ./documentDetails/addresseeIntermediator='')"/>
														<xsl:when test="./@distribution='B2B' and count(invoice/invoiceRow/netAmount[.!=''])=count(invoice/invoiceRow/netAmount) and count(invoice/invoiceRow[(article/@id='' and article/name='')]) = 0  and count(invoice/invoiceRow)=count(invoice/invoiceRow/netAmount) and count(invoice/invoiceRow/quantity[.!=''])=count(invoice/invoiceRow/quantity) and ((invoice/buyer/contact/name!='' and invoice/buyer/contact/text!='') or invoice/invoiceDetails/projectReference/@id!='') and  count(invoice/invoiceRow/unitPrice[.!=''])=count(invoice/invoiceRow/unitPrice) and ./documentDetails/addresseeID!='' and invoice/epiDetails/beneficiary/account!='' and invoice/epiDetails/paymentInstructions/remittanceID!='' and invoice/epiDetails/paymentInstructions/instructedAmount!='' and invoice/epiDetails/paymentInstructions/optionDate!='' and count(invoice/invoiceDetails/vatAmount) &gt; 0 and invoice/invoiceDetails/invoiceTotal/vatAmount!='' and invoice/invoiceDetails/invoiceTotal/netAmount!='' and (substring(invoice/buyer/@id,1,2)='00' or substring(invoice/buyer/@id,1,1)='5' or substring(invoice/buyer/@id,1,1)='2' or substring(invoice/buyer/@id,1,2)='21' or invoice/buyer/@id='') and ./documentDetails/addresseeIntermediator!='SWEDSESS' and $boolForetag='true'">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolSwedbank">
													<xsl:choose>
														<xsl:when test="./@distribution='B2C'"/>
														<xsl:when test="./@distribution='B2B' and (./documentDetails/addresseeID='' or not(./documentDetails/addresseeID) or ./documentDetails/addresseeIntermediator!='SWEDSESS' or not(./documentDetails/addresseeIntermediator) or ./documentDetails/addresseeIntermediator='')"/>
														<xsl:when test="./@distribution='B2B' and count(invoice/invoiceRow/netAmount[.!=''])=count(invoice/invoiceRow/netAmount) and count(invoice/invoiceRow[(article/@id='' and article/name='')]) = 0   and count(invoice/invoiceRow)=count(invoice/invoiceRow/netAmount) and ./documentDetails/addresseeID!='' and invoice/epiDetails/beneficiary/account!='' and ((invoice/buyer/contact/name!='' and invoice/buyer/contact/text!='') or invoice/invoiceDetails/projectReference/@id!='') and  invoice/epiDetails/paymentInstructions/remittanceID!='' and invoice/epiDetails/paymentInstructions/instructedAmount!='' and invoice/epiDetails/paymentInstructions/optionDate!='' and count(invoice/invoiceDetails/vatAmount) &gt; 0 and invoice/invoiceDetails/invoiceTotal/vatAmount!='' and invoice/invoiceDetails/invoiceTotal/netAmount!='' and invoice/invoiceDetails/invoiceTotal/netAmount!='' and (substring(invoice/buyer/@id,1,2)='00' or substring(invoice/buyer/@id,1,1)='5' or substring(invoice/buyer/@id,1,1)='2' or substring(invoice/buyer/@id,1,2)='21' or invoice/buyer/@id='') and ./documentDetails/addresseeIntermediator!='NDEASESS' and $boolForetag='true'">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="invoiceReferenceId">
													<xsl:value-of select="invoice/buyer/bankCustomer/invoiceReference/@id"/>
												</xsl:variable>
												<xsl:variable name="Mod10Number">
													<xsl:if test="string(number($invoiceReferenceId))!='NaN'">
														<xsl:call-template name="Mod10Check">
															<xsl:with-param name="InValue">
																<xsl:value-of select="substring($invoiceReferenceId,1,string-length($invoiceReferenceId)-1)"/>
															</xsl:with-param>
														</xsl:call-template>
													</xsl:if>
												</xsl:variable>
												<xsl:variable name="LastCharacterInNumber">
													<xsl:value-of select="substring($invoiceReferenceId, string-length($invoiceReferenceId))"/>
												</xsl:variable>
												<xsl:variable name="Mod10Boolean">
													<xsl:if test="$LastCharacterInNumber = $Mod10Number">true</xsl:if>
												</xsl:variable>
												<xsl:variable name="buyerName">
													<xsl:call-template name="upperCase">
														<xsl:with-param name="input" select="invoice/buyer/postalAddress/name"/>
													</xsl:call-template>
												</xsl:variable>
												<xsl:variable name="efakturaKundEadress">
												</xsl:variable>
												<xsl:variable name="boolPotentiellEfaktura">
													<xsl:choose>
														<xsl:when test="$efakturaKundEadress!='' and $boolPrint='true' and $boolForetag!='true'">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolEfakturaCheck">
													<xsl:choose>
														<xsl:when test="$boolForetag='true'">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolBeloppKontroll">
													<xsl:choose>
														<xsl:when test="./@distribution='B2B' and sum(invoice/invoiceDetails/invoiceTotal/totalAmount[invoice/invoiceDetails/invoiceTotal/totalAmount!='']) = sum(invoice/invoiceDetails/invoiceTotal/roundingAmount[invoice/invoiceDetails/invoiceTotal/roundingAmount!=''])  + sum(invoice/invoiceDetails/invoiceTotal/netAmount[invoice/invoiceDetails/invoiceTotal/netAmount!=''])+sum(invoice/invoiceDetails/invoiceTotal/vatAmount[invoice/invoiceDetails/invoiceTotal/vatAmount!='']) and sum(invoice/invoiceDetails/invoiceTotal/vatAmount[invoice/invoiceDetails/invoiceTotal/vatAmount!=''])!=sum(invoice/invoiceDetails/vatAmount[invoice/invoiceDetails/vatAmount!=''])">false</xsl:when>
														<xsl:when test="sum(invoice/invoiceDetails/invoiceTotal/totalAmount[invoice/invoiceDetails/invoiceTotal/totalAmount!='']) = sum(invoice/invoiceDetails/invoiceTotal/roundingAmount[invoice/invoiceDetails/invoiceTotal/roundingAmount!=''])  + sum(invoice/invoiceDetails/invoiceTotal/netAmount[invoice/invoiceDetails/invoiceTotal/netAmount!=''])+sum(invoice/invoiceDetails/invoiceTotal/vatAmount[invoice/invoiceDetails/invoiceTotal/vatAmount!=''])">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolBeloppRadKontroll">
													<xsl:choose>
														<xsl:when test="sum(invoice/invoiceDetails/invoiceTotal/netAmount[invoice/invoiceDetails/invoiceTotal/netAmount!='']) = (sum(invoice/invoiceDetails/expenses/netAmount[invoice/invoiceDetails/expenses/netAmount!=''])+sum(invoice/invoiceDetails/freightDetails/freightAmount[invoice/invoiceDetails/freightDetails/freightAmount!=''])+sum(invoice/invoiceRow/netAmount[invoice/invoiceRow/netAmount!='']))">true</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolWarning">
													<xsl:choose>
														<xsl:when test="invoice/invoiceDetails/invoiceType!='Debet' and invoice/invoiceDetails/invoiceType!='debet' and (invoice/invoiceRow/article/name!=invoice/invoiceRow/unitPrice and invoice/invoiceRow/article/name!=invoice/invoiceRow/netAmount and invoice/invoiceRow/article/name!=invoice/invoiceRow/totalAmount)">true</xsl:when>
														<xsl:when test="(invoice/invoiceDetails/invoiceType='Autogiro' or invoice/invoiceDetails/invoiceType='autogiro') and invoice/invoiceDetails/invoiceType/@code!='INV03'">false</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:variable name="boolWarningRow">
													<xsl:choose>
														<xsl:when test="invoice/invoiceRow/totalAmount!='' and invoice/invoiceRow/unitPrice='' and invoice/invoiceRow/quantity=''">true</xsl:when>
														<xsl:when test="invoice/invoiceRow/netAmount!='' and invoice/invoiceRow/unitPrice='' and invoice/invoiceRow/quantity=''">true</xsl:when>
														<xsl:when test="invoice/invoiceRow/unitPrice!='' and invoice/invoiceRow/quantity=''">false</xsl:when>
														<xsl:when test="invoice/invoiceRow/unitPrice='' and invoice/invoiceRow/quantity!=''">false</xsl:when>
														<xsl:otherwise>false</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<td>
													<xsl:choose>
														<xsl:when test="$boolGenerellt='true'">
															<xsl:attribute name="bgcolor">#009900</xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="$boolPrint='true'">
															<xsl:attribute name="bgcolor">#009900</xsl:attribute>
														</xsl:when>
														<xsl:when test="$boolPrint=''">
															<xsl:attribute name="bgcolor">#FFFF00</xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="$boolPrivat='true'">
															<xsl:attribute name="bgcolor">#009900</xsl:attribute>
														</xsl:when>
														<xsl:when test="$boolPrivat=''">
															<xsl:attribute name="bgcolor">#FFFF00</xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="$boolForetag='true'">
															<xsl:attribute name="bgcolor">#009900</xsl:attribute>
														</xsl:when>
														<xsl:when test="$boolForetag=''">
															<xsl:attribute name="bgcolor">#FFFF00</xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="$boolNordea='true'">
															<xsl:attribute name="bgcolor">#009900</xsl:attribute>
														</xsl:when>
														<xsl:when test="$boolNordea=''">
															<xsl:attribute name="bgcolor">#FFFF00</xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="$boolSwedbank='true'">
															<xsl:attribute name="bgcolor">#009900</xsl:attribute>
														</xsl:when>
														<xsl:when test="$boolSwedbank=''">
															<xsl:attribute name="bgcolor">#FFFF00</xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="$boolSvefaktura='true' and $boolSvefakturaAdress='true'">
															<xsl:attribute name="bgcolor">#009900</xsl:attribute>
														</xsl:when>
														<xsl:when test="$boolSvefaktura='true' and $boolSvefakturaAdress='false'">
															<xsl:attribute name="bgcolor">#FF7F50</xsl:attribute>
														</xsl:when>
														<xsl:when test="$boolSvefaktura=''">
															<xsl:attribute name="bgcolor">#FFFF00</xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="$boolBeloppKontroll='true'">
															<xsl:attribute name="bgcolor">#009900</xsl:attribute>
														</xsl:when>
														<xsl:when test="$boolBeloppKontroll=''">
															<xsl:attribute name="bgcolor">#FFFF00</xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="$boolBeloppRadKontroll='true'">
															<xsl:attribute name="bgcolor">#009900</xsl:attribute>
														</xsl:when>
														<xsl:when test="$boolBeloppRadKontroll=''">
															<xsl:attribute name="bgcolor">#FFFF00</xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="bgcolor">#FF0000</xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="$boolPotentiellEfaktura='true'">
															<xsl:attribute name="bgcolor">#009900</xsl:attribute>
														</xsl:when>
														<xsl:when test="$boolPotentiellEfaktura=''">
															<xsl:attribute name="bgcolor"/>
														</xsl:when>
													</xsl:choose>
												</td>
												<td>
													<xsl:if test="$boolGenerellt='false'">
														<b>
															<u>Generella kontroller</u>
														</b>
														<br/>
														<xsl:if test="/batch/@id!='' or not(/batch/@id)">Id måste vara tomt (batch/@id)<br/>
														</xsl:if>
														<xsl:if test="/batch/batchDetails/bgnr='' or not(/batch/batchDetails/bgnr)">Avtalsbgnr saknas (batch/batchDetails/bgnr)<br/>
														</xsl:if>
														<xsl:if test=" 10!=string-length(/batch/batchDetails/bgnr)">Avtalsbgnr måste vara 10 tecken (batch/batchDetails/bgnr)<br/>
														</xsl:if>
														<xsl:if test=" substring(/batch/batchDetails/bgnr,1,2)!='00'">Avtalsbgnr är ej korrekt, inleds ej med två nollor (batch/batchDetails/bgnr)<br/>
														</xsl:if>
														<xsl:if test="/batch/section/@bgnr='' or not(/batch/section/@bgnr)">Avtalsbgnr saknas (batch/section/@bgnr)<br/>
														</xsl:if>
														<xsl:if test=" 10!=string-length(/batch/section/@bgnr)">Avtalsbgnr måste vara 10 tecken (batch/section/@bgnr)<br/>
														</xsl:if>
														<xsl:if test=" substring(/batch/section/@bgnr,1,2)!='00'">Avtalsbgnr är ej korrekt, inleds ej med två nollor (batch/batchDetails/bgnr)<br/>
														</xsl:if>
														<xsl:if test="/batch/section/document/documentDetails/originatorBgnr='' or not(/batch/section/document/documentDetails/originatorBgnr)">Avtalsbgnr saknas (/batch/section/document/documentDetails/originatorBgnr)<br/>
														</xsl:if>
														<xsl:if test=" 10!=string-length(/batch/section/document/documentDetails/originatorBgnr)">Avtalsbgnr måste vara 10 tecken (documentDetails/originatorBgnr)<br/>
														</xsl:if>
														<xsl:if test="substring(/batch/section/document/documentDetails/originatorBgnr,1,2)!='00'">Avtalsbgnr är ej korrekt, inleds ej med två nollor (/batch/section/document/documentDetails/originatorBgnr)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceType='' or not(invoice/invoiceDetails/invoiceType)">Rubrik saknas (invoice/invoiceDetails/invoiceType)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceNumber='' or not(invoice/invoiceDetails/invoiceNumber)">Fakturanr saknas (invoice/invoiceDetails/invoiceNumber)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceDate='' or not(invoice/invoiceDetails/invoiceDate)">Fakturadatum saknas (invoice/invoiceDetails/invoiceDate)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceTotal/totalAmount='' or not(invoice/invoiceDetails/invoiceTotal/totalAmount)">Belopp saknas (invoice/invoiceDetails/invoiceTotal/totalAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/@id='' or not(invoice/seller/@id)">Organisationsnr saknas (invoice/seller/@id)<br/>
														</xsl:if>
														<xsl:if test="10!=string-length(string(invoice/seller/@id)) and 11!=string-length(string(invoice/seller/@id))">Orgnr har felaktig längd. Förväntat värde 10-11 tecken (invoice/seller/@id)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/name='' or not(invoice/seller/name)">Namn saknas (invoice/seller/name)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/postalAddress/name='' or not(invoice/seller/postalAddress/name)">Namn saknas (invoice/seller/postalAddress/name)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/postalAddress/street='' or not(invoice/seller/postalAddress/street)">Gata saknas (invoice/seller/postalAddress/street)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/postalAddress/town='' or not(invoice/seller/postalAddress/town)">Postort saknas (invoice/seller/postalAddress/town)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/postalAddress/town/@postCode='' or not(invoice/seller/postalAddress/town/@postCode)">Postnr saknas (invoice/seller/postalAddress/town/@postCode)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/postalAddress/name!=invoice/seller/name">Namn skiljer sig åt (seller/postalAddress/name, invoice/seller/name)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/name='' or not(invoice/buyer/name)">Namn saknas (invoice/buyer/name)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/name='' or not(invoice/buyer/postalAddress/name)">Namn saknas (invoice/buyer/postalAddress/name)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/street='' or not(invoice/buyer/postalAddress/street)">Gata saknas (invoice/buyer/postalAddress/street)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/town='' or not(invoice/buyer/postalAddress/town)">Postort saknas (invoice/buyer/postalAddress/town)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/town/@postCode='' or not(invoice/buyer/postalAddress/town/@postCode)">Postnr saknas (invoice/buyer/postalAddress/town/@postCode)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/name!=invoice/buyer/name">Namn skiljer sig åt (buyer/postalAddress/name, invoice/buyer/name)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/dueDate='' or not(invoice/payment/dueDate)">Förfallodatum saknas (invoice/payment/dueDate)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/totalAmount='' or not(invoice/payment/totalAmount)">Belopp saknas (invoice/payment/totalAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/accounts/account='' or not(invoice/seller/accounts/account)">Inbetalningsgironr saknas (invoice/seller/accounts/account)<br/>
														</xsl:if>
														<xsl:if test="contains(invoice/seller/vatDetails/vatNumber, '-')">Momsregnr får ej innehålla bindestreck (seller/vatDetails/vatNumber)<br/>
														</xsl:if>
														<xsl:if test="contains(invoice/seller/accounts/account, '-')">Inbetalningsgironr får ej innehålla bindestreck (seller/account/accounts)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/accounts/account[0]/@type!='BG'">Första inbetalningsgironr måste innehålla typ BG (seller/accounts/account/@type)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/mainContact/phone = invoice/seller/mainContact/fax and invoice/seller/mainContact/phone!=''">Varning: Telefon och fax har samma värde (seller/mainContact/phone, seller/mainContact/fax)<br/>
														</xsl:if>
														<xsl:if test="not(invoice/seller/mainContact/phone) and not(invoice/seller/mainContact/fax)">Varning: Telefon eller fax saknas (invoice/seller/mainContact/phone)<br/>
														</xsl:if>
														<xsl:if test="./@distribution!='B2B' and ./@distribution!='B2C' ">Korrekt typ saknas (document/@distribution='B2C' eller document/@distribution='B2B')<br/>
														</xsl:if>
														<xsl:if test="not(./@distribution)">Attribut distribution saknas (document/@distribution)<br/>
														</xsl:if>
														<xsl:if test="./@templateID!='1'">Korrekt mall saknas document/@templateID='1'<br/>
														</xsl:if>
														<xsl:if test="not(./@templateID)">Attribut templateID saknas (document/@templateID)<br/>
														</xsl:if>
														<xsl:if test="./@originPaper!='false'">Korrekt originPaper saknas document/@originPaper='false'<br/>
														</xsl:if>
														<xsl:if test="documentDetails/addresseeID/@type!='BGCID'">Korrekt BGCID saknas (documentDetails/addresseeID/@type'BGCID')<br/>
														</xsl:if>
														<xsl:if test="not(contains(invoice/enclosures/enclosureDetails/@mimeCode, '/'))  and 0!=string-length(string(invoice/enclosures/enclosureDetails/@mimeCode))">Bilagor måste innehålla en korrekt mimetyp. Ex application/pdf (enclosureDetails/@mimeCode)<br/>
														</xsl:if>
														<xsl:if test="(invoice/buyer/postalAddress/country/@code='SE' or invoice/buyer/postalAddress/country/@code='' or not(invoice/buyer/postalAddress/country/@code)) and string(number(translate(invoice/buyer/postalAddress/town/@postCode, ' ', '')))='NaN'">Köparens postnr är ej numeriskt (buyer/postalAddress/town/@postCode) och landskod avser Sverige. Gäller postnr i Sverige.<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/dueDate!=invoice/epiDetails/paymentInstructions/optionDate">Förfallodatum är olika (payment/dueDate!=epiDetails/paymentInstructions/optionDate)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceDetails/vatAmount) != count(invoice/invoiceDetails/vatAmount/@rate[.!=''])">Moms objektet är ej komplett. Uppgift saknas i rate (invoiceDetails/vatAmount/@rate)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceDetails/vatAmount) != count(invoice/invoiceDetails/vatAmount/@base)">Moms objektet är ej komplett. Uppgift saknas i base (invoiceDetails/vatAmount/@base)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/dueDate!=invoice/epiDetails/paymentInstructions/optionDate">Förfallodatum är ej lika (invoice/payment/dueDate och invoice/epiDetails/paymentInstructions/optionDate)<br/>
														</xsl:if>
														<xsl:if test="not(invoice/payment/dueDate)">Förfallodatum saknas (invoice/payment/dueDate)<br/>
														</xsl:if>
														<xsl:if test="not(invoice/epiDetails/paymentInstructions/optionDate)">Förfallodatum saknas (invoice/epiDetails/paymentInstructions/optionDate)<br/>
														</xsl:if>
														<xsl:if test="not(invoice/epiDetails)">Betalningsinstruktions objektet saknas och måste vara ifyllt (invoice/epiDetails)<br/>
														</xsl:if>
														<xsl:if test="not(invoice/payment)">Betalningsinstruktions objektet saknas och måste vara ifyllt (invoice/payment)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/identifier!='' and invoice/epiDetails/paymentInstructions/remittanceID != invoice/invoiceDetails/identifier">Betalningsinstruktionen måste inneha samma uppgift (invoiceDetails/identifier och paymentInstructions/remittanceID)<br/>
														</xsl:if>
														<xsl:for-each select="invoice/seller/accounts/account">
															<xsl:if test="string-length(.) &gt; 10 and ./@type='BG'">Ett bankgironr får max vara 10 tecken (seller/accounts/account)<br/>
															</xsl:if>
															<xsl:if test="string-length(.) &gt; 10 and ./@type='PG'">Ett plusgironr får max vara 10 tecken (seller/accounts/account)<br/>
															</xsl:if>															
														</xsl:for-each>
														<xsl:if test="invoice/invoiceDetails/invoiceNumber!=./@id or (invoice/invoiceDetails/identifier!=./@id and invoice/invoiceDetails/identifier!='')">Fakturanr ska anges i document/@id (invoiceNumber är ej lika med ./@id)<br/>
														</xsl:if>
													</xsl:if>
													<xsl:if test="$boolPrint='false'">
														<b>
															<u>Print kontrolleras</u>
														</b>
														<br/>
														<xsl:if test="$boolGenerellt='false'">Generella kontroller är felaktiga. Rätta de generella kontrollerna innan du testar om<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/name='' or not(invoice/seller/name)">Returadress: Namn saknas (invoice/seller/name)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/postalAddress/name='' or not(invoice/seller/postalAddress/name)">Returadress: Namn saknas (invoice/seller/postalAddress/name)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/postalAddress/street='' or not(invoice/seller/postalAddress/street)">Returadress: Gata saknas (invoice/seller/postalAddress/street)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/postalAddress/town='' or not(invoice/seller/postalAddress/town)">Returadress: Postort saknas (invoice/seller/postalAddress/town)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/postalAddress/town/@postCode='' or not(invoice/seller/postalAddress/town/@postCode)">Returadress: Postnr saknas (invoice/seller/postalAddress/town/@postCode)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/name='' or not(invoice/buyer/name)">Namn saknas (invoice/buyer/name)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/name='' or not(invoice/buyer/postalAddress/name)">Namn saknas (invoice/buyer/postalAddress/name)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/town='' or not(invoice/buyer/postalAddress/town)">Postort saknas (invoice/buyer/postalAddress/town)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/town/@postCode='' or not(invoice/buyer/postalAddress/town/@postCode)">Postnr saknas (invoice/buyer/postalAddress/town/@postCode)<br/>
														</xsl:if>
														<xsl:if test="(invoice/printInfo/languageCode!='SE' and invoice/printInfo/languageCode!='EN')">Korrekt språkkod saknas (invoice/printInfo/languageCode). Endast SE eller EN tillåts.<br/>
														</xsl:if>
														<xsl:if test="(invoice/printInfo/postage!='A' and invoice/printInfo/postage!='B')!=''">Korrekt porto saknas (invoice/printInfo/postage)<br/>
														</xsl:if>
														<xsl:if test="(invoice/printInfo/layout!='B2C01' and invoice/printInfo/layout!='B2C02' and invoice/printInfo/layout!='B2B01' and invoice/printInfo/layout!='B2B02') !=''">Korrekt mall saknas (invoice/printInfo/layout)<br/>
														</xsl:if>
														<xsl:if test="(invoice/printInfo/imageBase64/@height&gt;86) and invoice/printInfo/imageBase64/@height!=''">Höjden på bilden får max vara 85 punkter (invoice/printInfo/imageBase64/@height)<br/>
														</xsl:if>
														<xsl:if test="(invoice/printInfo/imageBase64/@width&gt;286) and invoice/printInfo/imageBase64/@width!=''">Bredden på bilden får max vara 285 punkter (invoice/printInfo/imageBase64/@width)<br/>
														</xsl:if>
														<xsl:if test="(invoice/printInfo/imageBase64/@mimeType!='image/jpg' and invoice/printInfo/imageBase64/@mimeType!='image/jpeg') and invoice/printInfo/imageBase64/@mimeType!=''">Bildens mimeType måste vara image/jpg (invoice/printInfo/imageBase64/@mimeType)<br/>
														</xsl:if>
														<xsl:if test="invoice/printInfo/imageBase64/data!='' and (invoice/printInfo/imageBase64/@width='' or not(invoice/printInfo/imageBase64/@width)) and (invoice/printInfo/imageBase64/@height='' or not(invoice/printInfo/imageBase64/@height))">Bild finns men ingen höjd eller bredd har angivets (invoice/printInfo/imageBase64/@width)<br/>
														</xsl:if>
														<xsl:if test="(invoice/printInfo/imageBase64/data='' or not(invoice/printInfo/imageBase64/data)) and invoice/printInfo/imageBase64/@width!=''">Bild data saknas. Bredd är angiven. (invoice/printInfo/imageBase64/data)<br/>
														</xsl:if>
														<xsl:if test="(invoice/printInfo/imageBase64/data='' or not(invoice/printInfo/imageBase64/data)) and invoice/printInfo/imageBase64/@height!=''">Bild data saknas. Höjd är angiven. (invoice/printInfo/imageBase64/data)<br/>
														</xsl:if>
														<xsl:if test="contains($buyer_SellerId, '------')">
															<b>Varning!</b> Kundnr innehåller flera bindestreck. <br/>Kan skapa problem vid samkuvertering. <br/>Kundnr måste vara unikt per kund.  (invoice/buyer/@sellerID)<br/>
														</xsl:if>
														<xsl:if test="contains($buyer_SellerId, '_____')">
															<b>Varning!</b> Kundnr innehåller flera bindestreck. <br/>Kan skapa problem vid samkuvertering. <br/>Kundnr måste vara unikt per kund.  (invoice/buyer/@sellerID)<br/>
														</xsl:if>
														<xsl:if test="contains($buyer_SellerId, '0000000000')">
															<b>Varning!</b> Kundnr innehåller flera nollor. <br/>Kan skapa problem vid samkuvertering. <br/>Kundnr måste vara unikt per kund. (invoice/buyer/@sellerID)<br/>
														</xsl:if>
														<xsl:if test="$buyer_SellerId=''">
															<b>Varning!</b> Kundnr får ej vara tomt. <br/>Kan skapa problem vid samkuvertering. <br/>Kundnr måste vara unikt per kund. (invoice/buyer/@sellerID)<br/>
														</xsl:if>
														<xsl:if test="$boolTotalAmountCredit='false'">Beloppet är negativt. Beloppet måste alltid vara positivt för B2C märkt faktura (invoiceTotal/totalAmount)<br/>
														</xsl:if>
														<xsl:if test="(invoice/invoiceDetails/invoiceTotal/vatAmount='' or not(invoice/invoiceDetails/invoiceTotal/vatAmount)) and count(invoice/invoiceDetails/vatAmount) = 0">
															<b>Varning!</b> Momsuppgift/momssats saknas (invoiceTotal/vatAmount eller invoiceDetails/vatAmount)<br/>
														</xsl:if>
														<xsl:if test="(invoice/printInfo/layout='B2C01' or invoice/printInfo/layout='B2C02') and count(invoice/invoiceRow/totalAmount)=0">B2C mall är vald men belopp saknas på rad (invoiceRow/totalAmount)<br/>
														</xsl:if>
														<xsl:if test="(invoice/printInfo/layout='B2B01' or invoice/printInfo/layout='B2B02') and count(invoice/invoiceRow/netAmount)=0">B2B mall är vald men belopp saknas på rad (invoiceRow/netAmount)<br/>
														</xsl:if>
														<xsl:if test="$boolInvoiceIdB2C!='true' and $boolInvoiceIdB2B!='true'">document/@id och invoice/@id ska för B2B sättas till fakturanr och om e-fakturan skickas till internetbanken så ska den sättas till OCRmr<br/>
														</xsl:if>
														<xsl:if test="$countBankgiroNumber=0">Inbetalningsbankgironummer saknas i sidfoten (accounts/account[type=BG])<xsl:value-of select="$countBankgiroNumber"/><br/>
														</xsl:if>
														<xsl:if test="substring(invoice/seller/accounts/account,1,2)!='00' and string-length(invoice/seller/accounts/account)=10">
															<b>Varning!</b> Inbetalnings bgnr verkar ej korrekt. Troligtvis har du lagt in företagets orgnr i stället för bgnr. Bgnr ska inledas med nollor(seller/accounts/account)<br/>
														</xsl:if>
														<xsl:if test="string-length(invoice/seller/accounts/account[0]) &gt; 6 and string-length(invoice/seller/accounts/account[0]) &lt; 11">
															<b>Varning!</b> Inbetalningsbgnr verkar vara för långt. Ska vara 7-10 tecken  (invoice/seller/accounts/account')<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/name = invoice/buyer/postalAddress/reference">
															<b>Varning!</b> Köparens namn och referens/enhet har samma information<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/name = invoice/buyer/postalAddress/street">
															<b>Varning!</b> Köparens namn och gata  har samma information<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/reference = invoice/buyer/postalAddress/street">
															<b>Varning!</b> Köparens enhet och gata  har samma information<br/>
														</xsl:if>
													</xsl:if>
													<xsl:if test="$boolPrivat='false'">
														<b>
															<u>E-privat kontrolleras</u>
														</b>
														<br/>
														<xsl:if test="$boolGenerellt='false'">Generella kontroller är felaktiga. Rätta de generella kontrollerna innan du testar om<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/bankCustomer/identifier[@type='BE']='' or not(invoice/buyer/bankCustomer/identifier[@type='BE'])">E-adress saknas (invoice/buyer/bankCustomer/identifier)<br/>
														</xsl:if>
														<xsl:if test="substring(invoice/buyer/bankCustomer/identifier[@type='BE'],1,4)='0000'">E-adress felaktig, inleds med nollor (invoice/buyer/bankCustomer/identifier)<br/>
														</xsl:if>
														<xsl:if test="16!=string-length(string(invoice/buyer/bankCustomer/identifier[@type='BE']))">E-adress felaktig, längd är ej 16 tecken (invoice/buyer/bankCustomer/identifier)<br/>
														</xsl:if>
														<xsl:if test="substring(invoice/buyer/bankCustomer/identifier[@type='BE'],5,2)!='18' and substring(invoice/buyer/bankCustomer/identifier[@type='BE'],5,2)!='19' and substring(invoice/buyer/bankCustomer/identifier[@type='BE'],5,2)!='20' and substring(invoice/buyer/bankCustomer/identifier[@type='BE'],5,4)!='0055'">E-adress felaktig, korrekt sekelsiffra saknas (invoice/buyer/bankCustomer/identifier)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/bankCustomer/invoiceReference/date='' or not(invoice/buyer/bankCustomer/invoiceReference/date)">Förfallodatum saknas (invoice/buyer/bankCustomer/invoiceReference/date)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/dueDate='' or not(invoice/payment/dueDate)">Förfallodatum saknas (invoice/payment/dueDate)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/dueDate!=invoice/buyer/bankCustomer/invoiceReference/date">Förfallodatum skiljer sig åt (invoice/payment/dueDate och invoice/buyer/bankCustomer/invoiceReference/date)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/bankCustomer/invoiceReference/@id='' or not(invoice/buyer/bankCustomer/invoiceReference/@id)">OCR saknas (invoice/buyer/bankCustomer/invoiceReference/@id)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/identifier='' or not(invoice/invoiceDetails/identifier) and (invoice/invoiceDetails/identifier/@type!='MED' or invoice/invoiceDetails/identifier/@type!='OCR')">OCR eller MED saknas (invoice/invoiceDetails/identifier[@type='OCR']) eller invoice/invoiceDetails/identifier[@type='MED'])<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceTotal/totalAmount='' or not(invoice/invoiceDetails/invoiceTotal/totalAmount)">Belopp saknas (invoice/invoiceDetails/invoiceTotal/totalAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/identifier!=invoice/buyer/bankCustomer/invoiceReference/@id">Referens överensstämmer ej (invoice/invoiceDetails/identifier=invoice/buyer/bankCustomer/invoiceReference/@id)<br/>
														</xsl:if>
														<xsl:if test="string(number(invoice/buyer/bankCustomer/invoiceReference/@id))='NaN'">OCR referens är ej numeriskt (invoice/buyer/bankCustomer/invoiceReference/@id)<br/>
														</xsl:if>
														<xsl:if test="$Mod10Boolean!='true' and invoice/invoiceDetails/identifier[@type='OCR']!=''">OCR referens är ej enligt 10 modul (invoice/buyer/bankCustomer/invoiceReference/@id)<br/>
														</xsl:if>
														<xsl:if test=" (invoice/printInfo/layout='B2C01' or invoice/printInfo/layout='B2C02') and count(invoice/invoiceRow/totalAmount)=0">B2C mall är vald men belopp saknas (invoiceRow/totalAmount)<br/>
														</xsl:if>
														<xsl:if test=" (invoice/printInfo/layout='B2B01' or invoice/printInfo/layout='B2B02') and count(invoice/invoiceRow/netAmount)=0">B2B mall är vald men belopp saknas (invoiceRow/netAmount)<br/>
														</xsl:if>
														<xsl:if test=" (invoice/payment/method/@code!='EG' and invoice/payment/method/@code!='EA')">Korrekt metod är ej angiven (invoice/payment/method/@code='EG')<br/>
														</xsl:if>
														<xsl:if test="$boolTotalAmountCredit='false'">Beloppet är negativt. Beloppet måste alltid vara positivt för B2C märkt faktura (invoiceTotal/totalAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/bankCustomer/invoiceMessage!=''">Varning: Meddelande elementet ska ej användas. (invoice/buyer/bankCustomer/invoiceMessage)<br/>
														</xsl:if>
														<xsl:if test="$boolInvoiceIdB2C!='true'">Betalningsinstruktion. Attributet identifier/@type måste vara MED eller OCR. Värde saknas eller är felaktigt angivet.<br/>
														</xsl:if>
														<xsl:if test="substring(invoice/seller/accounts/account,1,2)!='00' and string-length(invoice/seller/accounts/account)=10">
															<b>Varning!</b> Inbetalnings bgnr verkar ej korrekt. Troligtvis har du lagt in företagets orgnr i stället för bgnr. Bgnr ska inledas med nollor(seller/accounts/account)<br/>
														</xsl:if>
														<xsl:if test="string-length(invoice/seller/accounts/account[0]) &gt; 6 and string-length(invoice/seller/accounts/account[0]) &lt; 11">
															<b>Varning!</b> Inbetalningsbgnr verkar vara för långt. Ska vara 7-10 tecken  (invoice/seller/accounts/account')<br/>
														</xsl:if>
														<b>Varning!</b> Tänkt på att förfallodatumet måste vara minst dagens datum +1 dag för att det ska kunna skickas till internetbanken.<br/>
														<xsl:if test="invoice/buyer/postalAddress/name = invoice/buyer/postalAddress/reference">
															<b>Varning!</b> Köparens namn och referens/enhet har samma information<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/name = invoice/buyer/postalAddress/street">
															<b>Varning!</b> Köparens namn och gata  har samma information<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/reference = invoice/buyer/postalAddress/street">
															<b>Varning!</b> Köparens enhet och gata  har samma information<br/>
														</xsl:if>
													</xsl:if>
													<xsl:if test="$boolForetag='false'">
														<b>
															<u>E-företag kontrolleras</u>
														</b>
														<br/>
														<xsl:if test="$boolGenerellt='false'">Generella kontroller är felaktiga. Rätta de generella kontrollerna innan du testar om<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow/netAmount[.=''])=count(invoice/invoiceRow/netAmount)">Belopp saknas på en rad (invoice/invoiceRow/netAmount)<br/>
														</xsl:if>
														<xsl:if test="./documentDetails/addresseeID=''">E-adress saknas (./documentDetails/addresseeID)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow[(article/@id='' and article/name='')])!=0">Artikelnr eller namn saknas (invoiceRow/article/@id eller invoiceRow/article/name)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow/article/name[.!=''])=0">Artikelnamn saknas (invoiceRow/article/name)<br/>
														</xsl:if>
														<xsl:if test="./documentDetails/addresseeIntermediator!='BASWARE' and ./documentDetails/addresseeIntermediator!='DABASESS' and ./documentDetails/addresseeIntermediator!='HANDSESS' and ./documentDetails/addresseeIntermediator!='NDEASESS' and ./documentDetails/addresseeIntermediator!='ESSESESS' and ./documentDetails/addresseeIntermediator!='SWEDSESS' and ./documentDetails/addresseeIntermediator!='ITELLA' and ./documentDetails/addresseeIntermediator!='TIETOSE' and ./documentDetails/addresseeIntermediator!='LOGICA' and ./documentDetails/addresseeIntermediator!='PROCEEDO' and ./documentDetails/addresseeIntermediator!='HUSERA' and ./documentDetails/addresseeIntermediator!='EDB' and ./documentDetails/addresseeIntermediator!='STRALFORS1' and ./documentDetails/addresseeIntermediator!='BASWARE' and ./documentDetails/addresseeIntermediator!='INEXCHANGE' and ./documentDetails/addresseeIntermediator!='EXPERT' and ./documentDetails/addresseeIntermediator!=''">Korrekt operatörs adress saknas/ej korrekt (./documentDetails/addresseeIntermediator)<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/beneficiary/account=''">Inbetalnings gironr saknas (invoice/epiDetails/beneficiary/account')<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/paymentInstructions/remittanceID='' or not(invoice/epiDetails/paymentInstructions/remittanceID)">Inbetalningsreferens saknas (invoice/epiDetails/paymentInstructions/remittanceID')<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/paymentInstructions/instructedAmount='' or not(invoice/epiDetails/paymentInstructions/instructedAmount)">Belopp saknas (invoice/epiDetails/paymentInstructions/instructedAmount')<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/paymentInstructions/optionDate=''">Datum saknas (invoice/epiDetails/paymentInstructions/optionDate)<br/>
														</xsl:if>
														<xsl:if test="10!=string-length(invoice/seller/@id)">Orgnr saknas eller innehåller bindestreck (invoice/seller/@id')<br/>
														</xsl:if>
														<xsl:if test="14!=string-length(invoice/seller/vatDetails/vatNumber)">Momsregnr saknas/ej korrekt eller innehåller bindestreck (invoice/seller/vatDetails/vatNumber, SE[orgnr]01)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/dueDate='' or not(invoice/payment/dueDate)">Förfallodag saknas (invoice/payment/dueDate)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/totalAmount='' or not(invoice/payment/totalAmount)">Belopp saknas (invoice/payment/totalAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/accounts/account='' or not(invoice/seller/accounts/account)">Inbetalnings gironr saknas (invoice/seller/accounts/account)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceDetails/vatAmount) = 0">Momsspecifikation saknas (invoice/invoiceDetails/vatAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/vatAmount/@rate='' or not(invoice/invoiceDetails/vatAmount/@rate)">Momssats saknas (invoice/invoiceDetails/vatAmount/@rate)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/vatAmount/@base='' or not(invoice/invoiceDetails/vatAmount/@base)">Nettobelopp saknas (invoice/invoiceDetails/vatAmount/@base)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceTotal/vatAmount='' or not(invoice/invoiceDetails/invoiceTotal/vatAmount)">Moms belopp saknas (invoice/invoiceDetails/invoiceTotal/vatAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceTotal/netAmount='' or not(invoice/invoiceDetails/invoiceTotal/netAmount)">Netto belopp saknas (invoice/invoiceDetails/invoiceTotal/netAmount)<br/>
														</xsl:if>
														<xsl:if test="$boolBuyerGS1='false'">EANnr måste vara numeriskt eller tomt (invoice/buyer/gs1)<br/>
														</xsl:if>
														<xsl:if test="$boolSellerGS1='false'">EANnr måste vara numeriskt eller tomt (invoice/seller/gs1)<br/>
														</xsl:if>
														<xsl:if test="contains(documentDetails/addresseeID, '-')">E-adressen innehåller bindestreck (documentDetails/addresseeID)<br/>
														</xsl:if>
														<xsl:if test="(invoice/buyer/contact/name='' or invoice/buyer/contact/text='') or (not(invoice/buyer/contact/name) or not(invoice/buyer/contact/text)) and (invoice/invoiceDetails/projectReference/@id='' or not(invoice/invoiceDetails/projectReference/@id))">Köparens referens saknas (buyer/contact/name eller buyer/contact/text)<br/>
														</xsl:if>
														<xsl:if test="(invoice/buyer/contact/text='' or not(invoice/buyer/contact/text)) and (invoice/invoiceDetails/projectReference/@id='' or not(invoice/invoiceDetails/projectReference/@id))">Referens saknas (buyer/contact/text eller invoiceDetails/projectReference/@id)<br/>
														</xsl:if>
														<xsl:if test="$boolInvoiceIdB2B!='true'">document/@id och invoice/@id är inte samma som fakturanr<br/>
														</xsl:if>
														<xsl:if test="$boolSumRowNetAmount!='true'">Summan av radsummor (invoiceRow/netAmount) <xsl:value-of select="sum(invoice/invoiceRow/netAmount)"/> + avgifter (expenses/netAmount) <xsl:value-of select="sum(invoice/invoiceDetails/expenses/netAmount)"/> + frakt (freightAmount) <xsl:value-of select="sum(invoice/invoiceDetails/freightDetails/freightAmount)"/> överensstämmer ej med nettobeloppet (invoiceTotal/netAmount) <xsl:value-of select="invoice/invoiceDetails/invoiceTotal/netAmount"/>.<br/>
														<xsl:value-of select="sum(invoice/invoiceRow/netAmount) + sum(invoice/invoiceDetails/expenses/netAmount) + sum(invoice/invoiceDetails/freightDetails/freightAmount)"/>.<br/>
														</xsl:if>
														<xsl:if test="substring(invoice/seller/accounts/account,1,2)!='00' and string-length(invoice/seller/accounts/account)=10">
															<b>Varning!</b> Inbetalnings bgnr verkar ej korrekt. Troligtvis har du lagt in företagets orgnr i stället för bgnr. Bgnr ska inledas med nollor(seller/accounts/account)<br/>
														</xsl:if>
														<xsl:if test="string-length(invoice/seller/accounts/account[0]) &gt; 6 and string-length(invoice/seller/accounts/account[0]) &lt; 11">
															<b>Varning!</b> Inbetalningsbgnr verkar vara för långt. Ska vara 7-10 tecken  (invoice/seller/accounts/account')<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/name = invoice/buyer/postalAddress/reference">
															<b>Varning!</b> Köparens namn och referens/enhet har samma information<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/name = invoice/buyer/postalAddress/street">
															<b>Varning!</b> Köparens namn och gata  har samma information<br/>
														</xsl:if>
														<xsl:if test="invoice/buyer/postalAddress/reference = invoice/buyer/postalAddress/street">
															<b>Varning!</b> Köparens enhet och gata  har samma information<br/>
														</xsl:if>
													</xsl:if>
													<xsl:if test="$boolNordea='false'">
														<b>
															<u>Nordea kontrolleras</u>
														</b>
														<br/>
														<xsl:if test="$boolForetag='false'">Företagskontroller är felaktiga. Rätta felen innan du testar om.<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow[(article/@id='' and article/name='')])!=0">Artikelnr eller namn saknas (invoiceRow/article/@id eller invoiceRow/article/name)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow/article/name[.!=''])=0">Artikelnr eller namn saknas (invoiceRow/article/@id eller invoiceRow/article/name)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow/netAmount[.=''])=count(invoice/invoiceRow/netAmount)">Belopp saknas på en rad (invoice/invoiceRow/netAmount)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow)!=count(invoice/invoiceRow/netAmount)">Belopp saknas på en rad (invoice/invoiceRow/netAmount)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow/quantity[.=''])=count(invoice/invoiceRow/quantity)">Antal saknas på en rad (invoice/invoiceRow/quantity)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow/unitPrice[.=''])=count(invoice/invoiceRow/unitPrice)">Pris saknas på en rad (invoice/invoiceRow/unitPrice)<br/>
														</xsl:if>
														<xsl:if test="./documentDetails/addresseeID='' or not(./documentDetails/addresseeID)">E-adress saknas (./documentDetails/addresseeID)<br/>
														</xsl:if>
														<xsl:if test="./documentDetails/addresseeIntermediator!='NDEASESS'">Nordeas operatörs adress saknas/ej korrekt (./documentDetails/addresseeIntermediator)<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/beneficiary/account='' or not(invoice/epiDetails/beneficiary/account)">Inbetalnings gironr saknas (invoice/epiDetails/beneficiary/account')<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/paymentInstructions/remittanceID='' or not(invoice/epiDetails/paymentInstructions/remittanceID)">Inbetalningsreferens saknas (invoice/epiDetails/paymentInstructions/remittanceID')<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/paymentInstructions/instructedAmount='' or not(invoice/epiDetails/paymentInstructions/instructedAmount)">Belopp saknas (invoice/epiDetails/paymentInstructions/instructedAmount')<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/paymentInstructions/optionDate='' or not(invoice/epiDetails/paymentInstructions/optionDate)">Datum saknas (invoice/epiDetails/paymentInstructions/optionDate)<br/>
														</xsl:if>
														<xsl:if test=" 10!=string-length(invoice/seller/@id)">Orgnr saknas eller innehåller bindestreck (invoice/seller/@id')<br/>
														</xsl:if>
														<xsl:if test=" 14!=string-length(invoice/seller/vatDetails/vatNumber)">Momsregnr saknas eller innehåller bindestreck (seller/vatDetails/vatNumber', SE[orgnr]01)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/dueDate='' or not(invoice/payment/dueDate)">Förfallodag saknas (invoice/payment/dueDate)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/totalAmount='' or not(invoice/payment/totalAmount)">Belopp saknas (invoice/payment/totalAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/accounts/account='' or not(invoice/seller/accounts/account)">Inbetalnings gironr saknas (invoice/seller/accounts/account)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceDetails/vatAmount) = 0">Momsspecifikation saknas (invoice/invoiceDetails/vatAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceTotal/vatAmount='' or not(invoice/invoiceDetails/invoiceTotal/vatAmount)">Moms belopp saknas (invoice/invoiceDetails/invoiceTotal/vatAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceTotal/netAmount='' or not(invoice/invoiceDetails/invoiceTotal/netAmount)">Netto belopp saknas (invoice/invoiceDetails/invoiceTotal/netAmount)<br/>
														</xsl:if>
														<xsl:if test="(substring(invoice/buyer/@id,1,2)!='00' and substring(invoice/buyer/@id,1,1)!='5' and substring(invoice/buyer/@id,1,1)!='2' and substring(invoice/buyer/@id,1,2)!='21') and invoice/buyer/@id!=''">Köparens orgnr saknas eller är felaktigt (invoice/buyer/@id)<br/>
														</xsl:if>
														<xsl:if test="12!=string-length(./documentDetails/addresseeID) and 10!=string-length(./documentDetails/addresseeID) and 13!=string-length(./documentDetails/addresseeID) and 16!=string-length(./documentDetails/addresseeID)">E-adressen måste vara 10 eller 12 tecken, orgnr eller 13 tecken (EAN), 16 tecken(EAN) i längd (addresseeID)<br/>
														</xsl:if>
														<xsl:if test="(invoice/buyer/contact/name='' or invoice/buyer/contact/text='') or (not(invoice/buyer/contact/name) or not(invoice/buyer/contact/text)) and (invoice/invoiceDetails/projectReference/@id='' or not(invoice/invoiceDetails/projectReference/@id))">Köparens referens saknas (buyer/contact/name eller buyer/contact/text)<br/>
														</xsl:if>
														<xsl:if test="(invoice/buyer/contact/text='' or not(invoice/buyer/contact/text)) and (invoice/invoiceDetails/projectReference/@id='' or not(invoice/invoiceDetails/projectReference/@id))">Referens saknas (buyer/contact/text eller invoiceDetails/projectReference/@id)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow/netAmount) = 0">Belopp saknas på vissa rader (invoiceRow/netAmount)<br/>
														</xsl:if>
													</xsl:if>
													<xsl:if test="$boolSwedbank='false'">
														<b>
															<u>Swedbank kontrolleras</u>
														</b>
														<br/>
														<xsl:if test="$boolForetag='false'">Företagskontroller är felaktiga. Rätta felen innan du testar om.<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow[(article/@id='' and article/name='')])!=0">Artikelnr eller namn saknas (invoiceRow/article/@id eller invoiceRow/article/name)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow/netAmount[.=''])=count(invoice/invoiceRow/netAmount)">Belopp saknas på en rad (invoice/invoiceRow/netAmount)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow)!=count(invoice/invoiceRow/netAmount)">Belopp saknas på en rad (invoice/invoiceRow/netAmount)<br/>
														</xsl:if>
														<xsl:if test="./documentDetails/addresseeID=''">E-adress saknas (./documentDetails/addresseeID)<br/>
														</xsl:if>
														<xsl:if test="./documentDetails/addresseeIntermediator!='SWEDSESS'">Swedbanks operatörs adress saknas/ej korrekt (./documentDetails/addresseeIntermediator)<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/beneficiary/account=''">Inbetalnings gironr saknas (invoice/epiDetails/beneficiary/account')<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/paymentInstructions/remittanceID='' or not(invoice/epiDetails/paymentInstructions/remittanceID)">Inbetalningsreferens saknas (invoice/epiDetails/paymentInstructions/remittanceID')<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/paymentInstructions/instructedAmount='' or not(invoice/epiDetails/paymentInstructions/instructedAmount)">Belopp saknas (invoice/epiDetails/paymentInstructions/instructedAmount')<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/paymentInstructions/optionDate='' or not(invoice/epiDetails/paymentInstructions/optionDate)">Datum saknas (invoice/epiDetails/paymentInstructions/optionDate)<br/>
														</xsl:if>
														<xsl:if test=" 10!=string-length(invoice/seller/@id)">Orgnr saknas eller innehåller bindestreck (invoice/seller/@id')<br/>
														</xsl:if>
														<xsl:if test=" 14!=string-length(invoice/seller/vatDetails/vatNumber)">Momsregnr saknas eller innehåller bindestreck (invoice/seller/vatDetails/vatNumber', SE[orgnr]01)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/dueDate='' or not(invoice/payment/dueDate)">Förfallodag saknas (invoice/payment/dueDate)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/totalAmount='' or not(invoice/payment/totalAmount)">Belopp saknas (invoice/payment/totalAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/accounts/account='' or not(invoice/seller/accounts/account)">Inbetalnings gironr saknas (invoice/seller/accounts/account)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceDetails/vatAmount) = 0">Momsspecifikation saknas (invoice/invoiceDetails/vatAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceTotal/vatAmount='' or not(invoice/invoiceDetails/invoiceTotal/vatAmount)">Moms belopp saknas (invoice/invoiceDetails/invoiceTotal/vatAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceTotal/netAmount='' or not(invoice/invoiceDetails/invoiceTotal/netAmount)">Netto belopp saknas (invoice/invoiceDetails/invoiceTotal/netAmount)<br/>
														</xsl:if>
														<xsl:if test="(substring(invoice/buyer/@id,1,2)!='00' and substring(invoice/buyer/@id,1,1)!='5' and substring(invoice/buyer/@id,1,1)!='2' and substring(invoice/buyer/@id,1,2)!='21') and invoice/buyer/@id!=''">Köparens orgnr saknas eller är felaktigt (invoice/buyer/@id)<br/>
														</xsl:if>
														<xsl:if test="12!=string-length(./documentDetails/addresseeID) and 10!=string-length(./documentDetails/addresseeID) and 13!=string-length(./documentDetails/addresseeID) and 16!=string-length(./documentDetails/addresseeID)">E-adressen måste vara 10 eller 12 tecken, SE + orgnr eller 13 tecken (EAN), 16 tecken(EAN) i längd (addresseeID)<br/>
														</xsl:if>
														<xsl:if test="(invoice/buyer/contact/name='' or invoice/buyer/contact/text='') or (not(invoice/buyer/contact/name) or not(invoice/buyer/contact/text)) and (invoice/invoiceDetails/projectReference/@id='' or not(invoice/invoiceDetails/projectReference/@id))">Köparens referens saknas (buyer/contact/name eller buyer/contact/text)<br/>
														</xsl:if>
														<xsl:if test="(invoice/buyer/contact/text='' or not(invoice/buyer/contact/text)) and (invoice/invoiceDetails/projectReference/@id='' or not(invoice/invoiceDetails/projectReference/@id))">Referens saknas (buyer/contact/text eller invoiceDetails/projectReference/@id)<br/>
														</xsl:if>
													</xsl:if>
													<xsl:if test="$boolBeloppKontroll='false'">
														<b>Belopp i sidfoten kontrolleras</b>
														<br/>
														<xsl:if test="sum(invoice/invoiceDetails/invoiceTotal/totalAmount) != sum(invoice/invoiceDetails/invoiceTotal/netAmount[invoice/invoiceDetails/invoiceTotal/netAmount!=''])+sum(invoice/invoiceDetails/invoiceTotal/vatAmount[invoice/invoiceDetails/invoiceTotal/vatAmount!=''])+sum(invoice/invoiceDetails/invoiceTotal/roundingAmount[invoice/invoiceDetails/invoiceTotal/roundingAmount!=''])">Beloppen stämmer ej<br/>
(invoiceDetails/invoiceTotal/totalAmount) = (invoice/invoiceDetails/invoiceTotal/netAmount+invoice/invoiceDetails/invoiceTotal/vatAmount+invoice/invoiceDetails/invoiceTotal/roundingAmount)<br/>
															<xsl:value-of select="sum(invoice/invoiceDetails/vatAmount)"/>;<xsl:value-of select="sum(invoice/invoiceDetails/invoiceTotal/vatAmount)"/>
															<br/>
														</xsl:if>
														<xsl:if test="sum(invoice/invoiceDetails/invoiceTotal/vatAmount[invoice/invoiceDetails/invoiceTotal/vatAmount!=''])!=sum(invoice/invoiceDetails/vatAmount[invoice/invoiceDetails/vatAmount!=''])">Momsbeloppen stämmer ej mot totalen<br/>
(invoice/invoiceDetails/invoiceTotal/vatAmount=sum(invoice/invoiceDetails/vatAmount))<br/>
															<xsl:value-of select="sum(invoice/invoiceDetails/vatAmount)"/>;<xsl:value-of select="sum(invoice/invoiceDetails/invoiceTotal/vatAmount)"/>
															<br/>
														</xsl:if>
													</xsl:if>
													<xsl:if test="$boolBeloppRadKontroll='false'">
														<b>Nettobelopp i sidfoten samt radbeloppen kontrolleras</b>
														<br/>
														<xsl:if test="sum(invoice/invoiceDetails/invoiceTotal/netAmount) != (sum(invoice/invoiceDetails/expenses/netAmount)+sum(invoice/invoiceDetails/freightDetails/freightAmount)+sum(invoice/invoiceRow/netAmount))">Beloppen stämmer ej<br/>
(invoice/invoiceDetails/invoiceTotal/netAmount) = invoice/invoiceRow/netAmount+invoice/invoiceDetails/expenses/netAmount+invoice/invoiceDetails/freightDetails/freightAmount<br/>
															<br/>
														</xsl:if>
													</xsl:if>
													<xsl:if test="$boolSvefaktura='false'">
														<b>Svefaktura kontrolleras</b>
														<br/>
														<xsl:if test="count(invoice/invoiceRow/netAmount[.=''])=count(invoice/invoiceRow/netAmount)">Belopp saknas på en rad (invoice/invoiceRow/netAmount)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow)!=count(invoice/invoiceRow/netAmount)">Belopp saknas på en rad (invoice/invoiceRow/netAmount)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceRow[(article/@id='' and article/name='')])!=0">Artikelnr eller namn saknas (invoiceRow/article/@id eller invoiceRow/article/name)<br/>
														</xsl:if>
														<xsl:if test="./documentDetails/addresseeID=''">E-adress saknas (./documentDetails/addresseeID)<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/beneficiary/account=''">Inbetalnings gironr saknas (invoice/epiDetails/beneficiary/account')<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/paymentInstructions/remittanceID=''">Inbetalningsreferens saknas (invoice/epiDetails/paymentInstructions/remittanceID')<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/paymentInstructions/instructedAmount=''">Belopp saknas (invoice/epiDetails/paymentInstructions/instructedAmount')<br/>
														</xsl:if>
														<xsl:if test="invoice/epiDetails/paymentInstructions/optionDate=''">Datum saknas (invoice/epiDetails/paymentInstructions/optionDate)<br/>
														</xsl:if>
														<xsl:if test=" 10!=string-length(invoice/seller/@id)">Orgnr saknas eller innehåller bindestreck (invoice/seller/@id')<br/>
														</xsl:if>
														<xsl:if test=" 14!=string-length(invoice/seller/vatDetails/vatNumber)">Momsregnr saknas eller innehåller bindestreck (invoice/seller/vatDetails/vatNumber', SE[orgnr]01)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/dueDate=''">Förfallodag saknas (invoice/payment/dueDate)<br/>
														</xsl:if>
														<xsl:if test="invoice/payment/totalAmount=''">Belopp saknas (invoice/payment/totalAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/seller/accounts/account=''">Inbetalnings gironr saknas (invoice/seller/accounts/account)<br/>
														</xsl:if>
														<xsl:if test="count(invoice/invoiceDetails/vatAmount) = 0">Momsspecifikation saknas (invoice/invoiceDetails/vatAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceTotal/vatAmount=''">Moms belopp saknas (invoice/invoiceDetails/invoiceTotal/vatAmount)<br/>
														</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceTotal/netAmount=''">Netto belopp saknas (invoice/invoiceDetails/invoiceTotal/netAmount)<br/>
														</xsl:if>
														<xsl:if test="(substring(invoice/buyer/@id,1,2)!='00' and substring(invoice/buyer/@id,1,1)!='5' and substring(invoice/buyer/@id,1,1)!='2' and substring(invoice/buyer/@id,1,2)!='21') and invoice/buyer/@id!=''">Köparens orgnr saknas eller är felaktigt (invoice/buyer/@id)<br/>
														</xsl:if>
														<xsl:if test="(invoice/buyer/contact/name='' or invoice/buyer/contact/text='') or (not(invoice/buyer/contact/name) or not(invoice/buyer/contact/text)) and (invoice/invoiceDetails/projectReference/@id='' or not(invoice/invoiceDetails/projectReference/@id))">Köparens referens saknas (buyer/contact/name eller buyer/contact/text)<br/>
														</xsl:if>
														<xsl:if test="(invoice/buyer/contact/text='' or not(invoice/buyer/contact/text)) and (invoice/invoiceDetails/projectReference/@id='' or not(invoice/invoiceDetails/projectReference/@id))">Referens saknas (buyer/contact/text eller invoiceDetails/projectReference/@id)<br/>
														</xsl:if>
														<xsl:if test="substring(./documentDetails/addresseeID,1,2)!='SE' and substring(./documentDetails/addresseeID,1,2)!='73' and substring(./documentDetails/addresseeID,1,2)!='55' and substring(./documentDetails/addresseeID,1,2)!='21' and substring(./documentDetails/addresseeID,1,2)!='20'">E-adressen måste inledas med Orgnr (utan bindestreck) eller EANnr (addresseeID)<br/>
														</xsl:if>
														<xsl:if test="12!=string-length(./documentDetails/addresseeID) and 13!=string-length(./documentDetails/addresseeID) and 16!=string-length(./documentDetails/addresseeID)">Varning: IE-adressen måste vara 12 tecken, SE + orgnr eller 13 tecken (EAN), 16 tecken(EAN) i längd (addresseeID)<br/>
														</xsl:if>
													</xsl:if>
													<b>
														<u>Övrigt</u>
													</b>
													<br/>
													<xsl:if test="$boolPotentiellEfaktura='true'">
														<b>Stödjer e-faktura. Byt till adress: </b>
														<xsl:value-of select="$efakturaKundEadress"/>
													</xsl:if>
													<xsl:if test="$boolForetag='true'">
														<xsl:if test="substring(invoice/seller/accounts/account,1,1)='0'">
															Varning: Inbetalningsgironr bör inte innehålla inledande nollor (invoice/seller/accounts/account)</xsl:if>
													</xsl:if>
													<xsl:if test="$boolWarning='false'">
														<xsl:if test="invoice/invoiceDetails/invoiceType='Debet' or invoice/invoiceDetails/invoiceType='debet'">
															<br/>Varning: Kontrollera rubriken (invoice/invoiceDetails/invoiceType)
														</xsl:if>
														<xsl:if test="(invoice/invoiceRow/article/name=invoice/invoiceRow/unitPrice or invoice/invoiceRow/article/name=invoice/invoiceRow/netAmount or invoice/invoiceRow/article/name=invoice/invoiceRow/totalAmount)">
															<br/>Varning: Kontrollera att uppgifter på rader stämmer, benämning, antal och pris. Vissa uppgifter verkar vara lika.
														</xsl:if>
														<xsl:if test="(invoice/invoiceDetails/invoiceType='Autogiro' or invoice/invoiceDetails/invoiceType='autogiro') and invoice/invoiceDetails/invoiceType/@code!='INV03'">
															<br/>Varning: Kontrollera kod på fakturan. Rubriken är Autogiro men kod är ej INV03 (invoiceDetails/invoiceType/@code).
														</xsl:if>
													</xsl:if>
													<xsl:if test="$boolWarningRow='false'">
														<xsl:if test="invoice/invoiceRow/unitPrice=''">
															<br/>Varning: Ska pris på en rad vara blankt/tomt?
														</xsl:if>
														<xsl:if test="invoice/invoiceRow/quantity=''">
															<br/>Varning: Ska antal på en rad vara blankt/tomt?
														</xsl:if>
													</xsl:if>
													<xsl:if test="$boolEfakturaCheck='true'">
													</xsl:if>
													<xsl:for-each select="invoice/invoiceDetails/text">
														<xsl:if test="string-length(.) &gt; 200">
															<b>Varning!</b> Ett av meddelande fältet är för långt. Innehållet får max vara 200 tecken. Dela upp meddelande i flera text element  (invoice/invoiceDetails/text')<br/>
														</xsl:if>
														<xsl:if test="contains(., '&#xa;')">
															<b>Varning!</b> Ett av meddelande fältet innehåller radbrytningstecken vilket ej är tillåtet. Använd istället ett nytt text element. Dela upp meddelande i flera text element  (invoice/invoiceDetails/text')<br/>
														</xsl:if>
													</xsl:for-each>
													<xsl:for-each select="invoice/factoring/text">
														<xsl:if test="string-length(.) &gt; 200">
															<b>Varning!</b> Ett av meddelande/överlåtelse fältet är för långt. Innehållet får max vara 200 tecken. Dela upp meddelande i flera text element  (invoice/factoring/text')<br/>
														</xsl:if>
														<xsl:if test="contains(., '&#xa;')">
															<b>Varning!</b> Ett av meddelande/överlåtelse fältet innehåller radbrytningstecken vilket ej är tillåtet. Använd istället ett nytt text element. Dela upp meddelande i flera text element  (invoice/factoring/text')<br/>
														</xsl:if>
													</xsl:for-each>
												</td>
												<td>
													<xsl:value-of select="position()"/>
												</td>
												<td>
													<xsl:value-of select="invoice/seller/postalAddress/name"/>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="10=string-length(string(invoice/seller/@id))">
															<xsl:value-of select="substring(invoice/seller/@id,1,6)"/>-<xsl:value-of select="substring(invoice/seller/@id,7,4)"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="invoice/seller/@id"/>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td>
													<xsl:call-template name="show-gironr">
														<xsl:with-param name="gironr" select="./documentDetails/originatorBgnr"/>
													</xsl:call-template>
												</td>
												<td>
													<xsl:if test="invoice/invoiceDetails/invoiceType=''">
														<xsl:if test="invoice/invoiceDetails/invoiceType/@code='INV01'">Faktura</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceType/@code='INV02'">Kreditfaktura</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceType/@code='INV03'">Autogirofaktura</xsl:if>
														<xsl:if test="invoice/invoiceDetails/invoiceType/@code='INV04'">Räntefaktura</xsl:if>
													</xsl:if>
													<xsl:if test="invoice/invoiceDetails/invoiceType!=''">
														<xsl:value-of select="invoice/invoiceDetails/invoiceType"/>
													</xsl:if>
												</td>
												<td>
													<xsl:value-of select="invoice/invoiceDetails/invoiceType/@code"/>
												</td>
												<td>
													<xsl:value-of select="invoice/invoiceDetails/invoiceDate"/>
												</td>
												<td>
													<xsl:if test="./@distribution='B2C'">
														<xsl:choose>
															<xsl:when test="0!=string-length(invoice/buyer/bankCustomer/identifier[@type='BE'])">
																<xsl:value-of select="invoice/buyer/bankCustomer/invoiceReference/date"/>
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="invoice/payment/dueDate"/>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:if>
													<xsl:if test="./@distribution='B2B'">
														<xsl:value-of select="invoice/payment/dueDate"/>
													</xsl:if>
												</td>
												<td>
													<xsl:if test="./@distribution='B2C'">
														<xsl:choose>
															<xsl:when test="0!=string-length(invoice/buyer/bankCustomer/identifier[@type='BE'])">
																<xsl:value-of select="invoice/buyer/bankCustomer/invoiceReference/@id"/>
															</xsl:when>
															<xsl:otherwise>
																<xsl:if test="invoice/invoiceDetails/identifier/@type='OCR'">
																	<xsl:value-of select="invoice/invoiceDetails/identifier"/>
																</xsl:if>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:if>
													<xsl:if test="./@distribution='B2B'">
														<xsl:value-of select="invoice/invoiceDetails/identifier"/>
													</xsl:if>
												</td>
												<td align="right">
													<xsl:call-template name="show-amount">
														<xsl:with-param name="amount" select="invoice/invoiceDetails/invoiceTotal/netAmount"/>
													</xsl:call-template>
												</td>
												<td align="right">
													<xsl:call-template name="show-amount">
														<xsl:with-param name="amount" select="invoice/invoiceDetails/invoiceTotal/vatAmount"/>
													</xsl:call-template>
												</td>
												<td align="right">
													<xsl:call-template name="show-amount">
														<xsl:with-param name="amount" select="invoice/invoiceDetails/invoiceTotal/totalAmount"/>
													</xsl:call-template>
												</td>
												<td>
													<xsl:value-of select="invoice/invoiceDetails/invoiceTotal/totalAmount/@currency"/>
												</td>
												<td>
													<xsl:call-template name="show-gironr">
														<xsl:with-param name="gironr" select="invoice/seller/accounts/account[@type='BG']"/>
													</xsl:call-template>
												</td>
												<td>
													<xsl:if test="invoice/invoiceDetails/invoiceType/@code='INV01'">Faktura</xsl:if>
													<xsl:if test="invoice/invoiceDetails/invoiceType/@code='INV02'">Kreditfaktura</xsl:if>
													<xsl:if test="invoice/invoiceDetails/invoiceType/@code='INV03'">Autogiro</xsl:if>
													<xsl:if test="invoice/invoiceDetails/invoiceType/@code='INV04'">Räntefaktura</xsl:if>
												</td>
												<td>
													<xsl:if test="./@distribution='B2C'">B2C</xsl:if>
													<xsl:if test="./@distribution='B2B'">B2B</xsl:if>
												</td>
												<td>
													<xsl:value-of select="invoice/printInfo/layout"/>
												</td>
												<td>
													<xsl:value-of select="invoice/printInfo/postage"/>
												</td>
												<td>
													<xsl:if test="./@distribution='B2C'">
														<xsl:if test="invoice/buyer/bankCustomer/identifier/@type='BE'">
															<xsl:call-template name="show-bank">
																<xsl:with-param name="bank" select="substring(invoice/buyer/bankCustomer/identifier,1,4)"/>
															</xsl:call-template>
														</xsl:if>
													</xsl:if>
													<xsl:if test="./@distribution='B2B'">
														<xsl:if test="0!=string-length(documentDetails/addresseeIntermediator)">
															<xsl:value-of select="./documentDetails/addresseeID"/>.<xsl:value-of select="./documentDetails/addresseeIntermediator"/>
														</xsl:if>
														<xsl:if test="0=string-length(documentDetails/addresseeIntermediator)">
															<xsl:value-of select="./documentDetails/addresseeID"/>
														</xsl:if>
													</xsl:if>
												</td>
												<td>
													<xsl:value-of select="invoice/buyer/@sellerID"/>
												</td>
												<td>
													<xsl:value-of select="invoice/buyer/postalAddress/name"/>
												</td>
												<td>
													<xsl:value-of select="invoice/buyer/postalAddress/reference"/>
												</td>
												<td>
													<xsl:value-of select="invoice/buyer/postalAddress/street"/>
												</td>
												<td>
													<xsl:value-of select="invoice/buyer/postalAddress/town/@postCode"/>
												</td>
												<td>
													<xsl:value-of select="invoice/buyer/postalAddress/town"/>
												</td>
												<td>
													<xsl:value-of select="invoice/buyer/postalAddress/country/@code"/>
												</td>
												<td>
													<xsl:value-of select="invoice/buyer/postalAddress/country"/>
												</td>
												<td>
													<xsl:choose>
														<xsl:when test="invoice/buyer/contact/text!=''">
															<xsl:value-of select="invoice/buyer/contact/text"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="invoice/buyer/contact/name"/>
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td>
													<xsl:value-of select="invoice/invoiceDetails/projectReference/@id"/>
												</td>
												<td>
													<xsl:value-of select="invoice/buyer/@id"/>
												</td>
												<td>
													<xsl:value-of select="invoice/buyer/gs1"/>
												</td>
											</TR>
										</xsl:for-each>
									</xsl:for-each>
								</TABLE>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="show-amount">
		<xsl:param name="amount"/>
		<!--Choose if amount is pos or neg -->
		<xsl:choose>
			<xsl:when test="contains($amount, '-')">
				<xsl:value-of select='translate(translate(format-number($amount, "###,##0.00"), ",", "&#160;"), ".", ",")'/>
			</xsl:when>
			<xsl:when test="0=string-length($amount)"/>
			<xsl:otherwise>
				<xsl:value-of select='translate(translate(format-number($amount, "###,##0.00"), ",", "&#160;"), ".", ",")'/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="show-number">
		<xsl:param name="number"/>
		<!--Choose if amount is pos or neg -->
		<xsl:choose>
			<xsl:when test="contains($number, '-')">
				<xsl:value-of select='translate(translate(format-number($number, "###,###"), ",", "&#160;"), ".", ",")'/>
			</xsl:when>
			<xsl:when test="0=string-length($number)"/>
			<xsl:otherwise>
				<xsl:value-of select='translate(translate(format-number($number, "###,###"), ",", "&#160;"), ".", ",")'/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="show-bank">
		<xsl:param name="bank"/>
		<!--Choose if amount is pos or neg -->
		<xsl:choose>
			<xsl:when test="contains($bank, '0019')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.SEB
			</xsl:when>
			<xsl:when test="contains($bank, '0027')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.SHB
			</xsl:when>
			<xsl:when test="contains($bank, '0035')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.OEB
			</xsl:when>
			<xsl:when test="contains($bank, '0043')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.SKB
			</xsl:when>
			<xsl:when test="contains($bank, '0051')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.FSPA
			</xsl:when>
			<xsl:when test="contains($bank, '0078')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.NB
			</xsl:when>
			<xsl:when test="contains($bank, '0086')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.FINN
			</xsl:when>
			<xsl:when test="contains($bank, '0116')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.ICA
			</xsl:when>
			<xsl:when test="contains($bank, '0124')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.LFB
			</xsl:when>
			<xsl:when test="contains($bank, '0159')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.SYD
			</xsl:when>			
			<xsl:when test="contains($bank, '0166')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.MARG
			</xsl:when>			
			<xsl:when test="contains($bank, '0182')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.SBAB
			</xsl:when>			
			<xsl:when test="contains($bank, '0208')">
				<xsl:value-of select="substring(invoice/buyer/bankCustomer/identifier,5,12)"/>.SHBF
			</xsl:when>			
			<xsl:otherwise>
				<xsl:value-of select="invoice/buyer/bankCustomer/identifier"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="show-gironr">
		<xsl:param name="gironr"/>
		<xsl:choose>
			<xsl:when test="contains($gironr, '-')">
				<xsl:value-of select="gironr"/>
			</xsl:when>
			<xsl:when test="0=string-length($gironr)"/>
			<xsl:otherwise>
				<xsl:value-of select='translate(format-number($gironr, "####,####"), ",", "-")'/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Mod10Check">
		<xsl:param name="InValue"/>
		<xsl:param name="NowPosIn"/>
		<xsl:param name="NowValue">0</xsl:param>
		<xsl:param name="CurCheckNum">2</xsl:param>
		<xsl:variable name="NowPos">
			<xsl:choose>
				<xsl:when test="string-length($NowPosIn)=0">
					<xsl:value-of select="string-length($InValue)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$NowPosIn"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$NowPos &gt; 0">
				<xsl:variable name="iTemp1" select="number(substring($InValue,$NowPos,1)) * $CurCheckNum"/>
				<xsl:variable name="iTemp2">
					<xsl:choose>
						<xsl:when test="$iTemp1 &gt; 9">
							<xsl:value-of select="$iTemp1 - 9"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$iTemp1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="Mod10Check">
					<xsl:with-param name="InValue" select="$InValue"/>
					<xsl:with-param name="NowPosIn" select="$NowPos - 1"/>
					<xsl:with-param name="NowValue" select="$NowValue + $iTemp2"/>
					<xsl:with-param name="CurCheckNum">
						<xsl:choose>
							<xsl:when test="$CurCheckNum=2 ">1</xsl:when>
							<xsl:otherwise>2</xsl:otherwise>
						</xsl:choose>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="NowValue2" select="format-number($NowValue,'00')"/>
				<xsl:variable name="NextUpTen" select="concat(substring($NowValue2,string-length($NowValue2)-1,1)+1,'0')"/>
				<xsl:value-of select="substring($NextUpTen - $NowValue,string-length($NextUpTen - $NowValue),1)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="upperCase">
		<xsl:param name="input"/>
		<xsl:variable name="vLowercaseChars_CONST" select="'abcdefghijklmnopqrstuvwxyz'"/>
		<xsl:variable name="vUppercaseChars_CONST" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
		<xsl:value-of select="translate($input, $vLowercaseChars_CONST , $vUppercaseChars_CONST)"/>
	</xsl:template>
</xsl:stylesheet>
