<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="2.0" encoding="iso-8859-1" indent="yes"/>
<xsl:template match="/"><xsl:variable name="countText" select="count(invoice/invoiceDetails/text)"/>
<xsl:variable name="countInvoiceRowId" select="count(invoice/invoiceRow[@id!=''])"/>
<xsl:variable name="countInvoiceRowArticleId" select='count(invoice/invoiceRow/article[@id!=""])'/>
<xsl:variable name="invoiceType" select="invoice/@type"/>
<xsl:variable name="invoiceB2C" select="'INV03'=string(invoice/@type) or 'B2C01'=string(/invoice/printInfo/layout) or 'B2C02'=string(/invoice/printInfo/layout)"/><html xsl:version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"><head><title>Presentation</title><meta http-equiv="imagetoolbar" content="no"/><meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/><style type="text/css">.t19b {font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 19px; font-style: bold;}.t12 {font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12px;}.t11 {font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11px;}.t10 {font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 10px;}.t9 {font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px;}.t8 {font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 8px;}INPUT{    COLOR: black}SELECT{    WIDTH: 100%}BODY{    BACKGROUND-IMAGE: url(templates/images/standardmall/backgrounds/bar2.gif);    BACKGROUND-REPEAT: repeat;    HEIGHT: 100%}DIV.backgroundbar{    BACKGROUND-POSITION: right bottom;    MIN-HEIGHT: 100%;    BACKGROUND-IMAGE: url(templates/images/standardmall/backgrounds/bar.gif);    WIDTH: 840px;    BACKGROUND-REPEAT: repeat-y;    BACKGROUND-COLOR: #ffffff}DIV.supercontainer{    WIDTH: 746px}DIV.maincontent{    MIN-HEIGHT: 100%;    HEIGHT: 100%}DIV.fl{    FLOAT: left}DIV.fr{    FLOAT: right}DIV.contenthead DIV.text{    MARGIN-LEFT: 425px;    WIDTH: 300px;    COLOR: white;    PADDING-TOP: 54px}DIV.break{    CLEAR: both;    OVERFLOW: hidden;    HEIGHT: 1px}.horzdots{    BACKGROUND-IMAGE: url(templates/images/standardmall/hdots.gif);    BACKGROUND-REPEAT: repeat-x;    HEIGHT: 3px}.vertdots{    BACKGROUND-POSITION: center top;    BACKGROUND-IMAGE: url(templates/images/standardmall/vdots.gif);    WIDTH: 3px;    BACKGROUND-REPEAT: repeat-y}TABLE.rowtable{    MARGIN: 4px}DIV.headerbg{    BACKGROUND-POSITION: left top;    BACKGROUND-IMAGE: url(templates/images/standardmall/backgrounds/header.gif);    BACKGROUND-REPEAT: repeat-x;    HEIGHT: 93px}table.detailedTable {border-width: 1px 1px 1px 1px;padding: 1px 1px 1px 1px;border-style: solid solid solid solid;border-color: black black black black;border-collapse: collapse;background-color: white;}td.detailedTable {border-width: 1px 1px 1px 1px;padding: 1px 1px 1px 1px;border-style: solid solid solid solid;border-color: black black black black;border-collapse: collapse;background-color: white;font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 12px;}</style></head><body bgcolor="#FFFFFF"><div class="backgroundbar"><div class="supercontainer"><div class="headerbg"><div class="fr"/></div><br clear="all"/><xsl:choose><xsl:when test="invoice/buyer/bankCustomer/identifier!='' and (contains(invoice/enclosures/enclosureDetails/@mimeCode,'pdf') or contains(invoice/enclosures/enclosureDetails/@mimeCode,'PDF')) and invoice/enclosures/enclosureDetails/encodedObject/data!=''"><table border="0" cellpadding="0" cellspacing="0" width="800"><tr><td valign="top" class="t11" align="left"><span class="t19b"><div class="fl"><xsl:call-template name="imageTop"/></div></span></td><td><table border="0" cellpadding="0" cellspacing="0" width="345"><tr><td><span class="t11"><strong>Utskriftsdatum</strong></span></td><td><span class="t11"><strong>OCR-referens</strong></span></td></tr><tr><td><span class="t12"><xsl:value-of select="invoice/invoiceDetails/invoiceDate"/></span></td><td><span class="t12"><xsl:choose><xsl:when test="invoice/invoiceDetails/identifier[@type='MED' or @type='OCR']!=''"><xsl:value-of select="invoice/invoiceDetails/identifier[@type='MED' or @type='OCR']"/></xsl:when><xsl:otherwise><xsl:value-of select="invoice/@id"/></xsl:otherwise></xsl:choose></span></td></tr><tr align="left" valign="top"><td>&#160;</td><td>&#160;</td></tr><tr align="left" valign="top"><td><span class="t11"><strong>Frfallodatum</strong></span></td><td><span class="t11"><strong>Att Betala</strong></span></td></tr><tr align="left" valign="top"><td><span class="t12"><xsl:value-of select="invoice/payment/dueDate"/></span></td><td><span class="t12"><xsl:choose><xsl:when test="invoice/payment/totalAmount='0.00'">Se <xsl:value-of select="invoice/invoiceDetails/invoiceType"/></xsl:when><xsl:otherwise><xsl:value-of select='translate(translate(format-number(invoice/payment/totalAmount, "###,##0.00"), ",", "&#160;"), ".", ",")'/></xsl:otherwise></xsl:choose></span></td></tr></table></td><td align="left" valign="top">&#160;</td></tr><tr><td> </td><td align="left" valign="top">&#160;</td></tr><tr><td width="300"><span class="t11"><strong>Avsndare:</strong></span></td><td valign="top"><span class="t11"><strong>Mottagare:</strong></span></td><td align="left" valign="top"> </td></tr><tr><td valign="top"><span class="t12"><xsl:call-template name="sellerName"/></span></td><td valign="top"><span class="t12"><xsl:call-template name="buyerName"/></span></td><td align="left" valign="top"> </td></tr><xsl:if test="$countText!=0"><tr align="left" valign="top"><td colspan="3"><br/><span class="t11"><strong>Meddelande</strong></span><br/><span class="t11"><xsl:for-each select="invoice/invoiceDetails/text"><xsl:value-of select="."/><br/></xsl:for-each></span></td></tr></xsl:if><tr align="left" valign="top"><td colspan="3"><hr/></td><td> </td></tr><tr align="left" valign="top"><td colspan="3"><span class="t11"><strong>Klicka p lnken ovan fr att se Er<xsl:if test="contains(invoice/invoiceDetails/invoiceType,'Frskringsbrev') or contains(invoice/invoiceDetails/invoiceType,'Kontoutdrag')">t</xsl:if>&#160;<xsl:value-of select="invoice/invoiceDetails/invoiceType"/> som PDF.</strong></span></td></tr><tr align="left" valign="top"><td colspan="3"><hr/></td><td> </td></tr><tr align="left" valign="top"><td colspan="3"><span class="t11"><strong>Viktigt! </strong>Vid eventuella svrigheter att se fakturan/bilagan. Kontrollera att instllningen fr "Spara inte krypterade sidor p disken" ej r markerad. Instllningen hittar du under Verktyg, internetalternativ och fliken avancerat i Internet Explorer7.x.</span></td></tr></table></xsl:when><xsl:otherwise><table width="770" border="0" cellspacing="0" cellpadding="0"><xsl:if test="invoice/printInfo/text='imageRight'"><tr><td colspan="3" align="right" valign="top"><xsl:call-template name="imageTop"/></td></tr></xsl:if><tr><td width="410" align="left" valign="top"><table width="310" border="0" cellspacing="0" cellpadding="0"><tr bgcolor="white"><td colspan="5"/></tr><tr><td width="410" valign="top"><table width="410" border="0" cellspacing="0" cellpadding="0"><tr><td width="3" class="t10"><br/><br/><br/><br/><br/><br/><br/></td><td valign="top" class="t11" align="left"><span class="t19b"><div class="fl"><xsl:if test="invoice/printInfo/text!='imageRight' or not(invoice/printInfo/text)"><xsl:call-template name="imageTop"/></xsl:if></div></span><br/></td><td width="3"/></tr></table></td><td width="1" bgcolor="white"/></tr><tr bgcolor="white"><td colspan="5"/></tr></table></td><td width="10" class="t11" valign="top"/><td width="300" align="left" valign="top"><xsl:choose><xsl:when test="invoice/invoiceDetails/invoiceType!=''"><span class="t19b"><xsl:value-of select="invoice/invoiceDetails/invoiceType"/></span></xsl:when><xsl:when test="'INV02'=string(invoice/@type)"><span class="t19b">KREDITFAKTURA</span></xsl:when><xsl:when test="'INV03'=string(invoice/@type)"><span class="t19b">AUTOGIROAVISERING</span></xsl:when><xsl:when test="'INV04'=string(invoice/@type)"><span class="t19b">RNTEFAKTURA</span></xsl:when><xsl:otherwise><span class="t19b">FAKTURA</span></xsl:otherwise></xsl:choose><span class="t8"><br/><br/></span><table class="detailedTable" width="360" border="0" cellspacing="1" cellpadding="1"><tr><xsl:if test="invoice/buyer/@sellerID!='' or invoice/invoiceDetails/customerReferenceNumber!=''"><td valign="top" class="t12" align="left"><xsl:choose><xsl:when test="contains(invoice/invoiceDetails/invoiceType, 'avi')"><span class="t10">Avinr<br/></span></xsl:when><xsl:when test="contains(invoice/invoiceDetails/invoiceType, 'AVI')"><span class="t10">Avinr<br/></span></xsl:when><xsl:otherwise><span class="t10">Fakturanummer<br/></span></xsl:otherwise></xsl:choose><xsl:value-of select="invoice/invoiceDetails/invoiceNumber"/></td><td class="detailedTable" valign="top" align="left"><xsl:choose><xsl:when test="contains(invoice/invoiceDetails/invoiceType, 'avi')"><span class="t10">&#160;Pers-/Org-/Kundnr<br/>&#160;</span></xsl:when><xsl:when test="contains(invoice/invoiceDetails/invoiceType, 'AVI')"><span class="t10">&#160;Pers-/Org-/Kundnr<br/>&#160;</span></xsl:when><xsl:otherwise><span class="t10">&#160;Kundnummer<br/>&#160;</span></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="invoice/buyer/@sellerID!=''"><xsl:value-of select="invoice/buyer/@sellerID"/></xsl:when><xsl:otherwise><xsl:value-of select="invoice/invoiceDetails/customerReferenceNumber"/></xsl:otherwise></xsl:choose></td></xsl:if><xsl:if test="0=string-length(invoice/buyer/@sellerID) and  0=string-length(invoice/invoiceDetails/customerReferenceNumber)"><td class="detailedTable" valign="top" align="left"><xsl:choose><xsl:when test="contains(invoice/invoiceDetails/invoiceType, 'avi')"><span class="t10">Avinr<br/></span></xsl:when><xsl:when test="contains(invoice/invoiceDetails/invoiceType, 'AVI')"><span class="t10">Avinr<br/></span></xsl:when><xsl:otherwise><span class="t10">Fakturanummer<br/></span></xsl:otherwise></xsl:choose><xsl:value-of select="invoice/invoiceDetails/invoiceNumber"/></td></xsl:if><td valign="top" class="t12" align="left"><xsl:choose><xsl:when test="contains(invoice/invoiceDetails/invoiceType, 'avi')"><span class="t10">&#160;Datum<br/>&#160;</span></xsl:when><xsl:when test="contains(invoice/invoiceDetails/invoiceType, 'AVI')"><span class="t10">&#160;Datum<br/>&#160;</span></xsl:when><xsl:otherwise><span class="t10">&#160;Datum<br/>&#160;</span></xsl:otherwise></xsl:choose><xsl:value-of select="invoice/invoiceDetails/invoiceDate"/></td></tr></table></td></tr></table><span class="t8"><br/></span><table class="rowtable" width="730" border="0" cellspacing="0" cellpadding="0"><tr><td width="390" align="left" valign="top"><table width="390" border="0" cellspacing="0" cellpadding="0"><tr bgcolor="white"><td colspan="5">&#160;</td></tr><tr><td width="390" valign="top"><table width="390" border="0" cellspacing="0" cellpadding="0"><xsl:if test="invoice/delivery/deliveree/deliveryAddress/name!='' or invoice/delivery/deliveree/deliveryAddress/street!=''"><tr><td valign="top" class="t12" align="left" colspan="2"><br/><span class="t10">Leveransadress</span><br/><xsl:call-template name="break"><xsl:with-param name="text" select="invoice/delivery/deliveree/deliveryAddress/name"/></xsl:call-template><br/><xsl:if test="invoice/delivery/deliveree/deliveryAddress/reference!=''"><xsl:value-of select="invoice/delivery/deliveree/deliveryAddress/reference"/><br/></xsl:if><xsl:for-each select="invoice/delivery/deliveree/deliveryAddress/street"><xsl:value-of select="."/>&#160;<xsl:value-of select="./@number"/><br/></xsl:for-each><xsl:if test="invoice/delivery/deliveree/deliveryAddress/country/@code!=''"><xsl:value-of select="invoice/delivery/deliveree/deliveryAddress/country/@code"/>-<xsl:value-of select="invoice/delivery/deliveree/deliveryAddress/town/@postCode"/>&#160;<xsl:value-of select="invoice/delivery/deliveree/deliveryAddress/town"/></xsl:if><xsl:if test="invoice/delivery/deliveree/deliveryAddress/country/@code='' or not(invoice/delivery/deliveree/deliveryAddress/country/@code)"><xsl:value-of select="invoice/delivery/deliveree/deliveryAddress/town/@postCode"/>&#160;<xsl:value-of select="invoice/delivery/deliveree/deliveryAddress/town"/></xsl:if><br/><xsl:value-of select="invoice/delivery/deliveree/deliveryAddress/country"/><br/><br/></td><td width="3"/></tr></xsl:if><tr><td valign="top" class="t12" align="left" colspan="2"><xsl:choose><xsl:when test="invoice/seller/salesContact/name!='' or invoice/seller/salesContact/phone!='' or invoice/seller/salesContact/email!=''"><span class="t10">Vr referens</span><br/><xsl:if test="invoice/seller/salesContact/name!=''"><xsl:value-of select="invoice/seller/salesContact/name"/>&#160;</xsl:if><xsl:if test="invoice/seller/salesContact/phone!=''"><xsl:value-of select="invoice/seller/salesContact/phone"/>&#160;</xsl:if><xsl:value-of select="invoice/seller/salesContact/email"/></xsl:when></xsl:choose><br/></td><td width="3"/></tr><tr><td valign="top" class="t12" align="left" colspan="2"><br/><xsl:choose><xsl:when test="invoice/buyer/contact/name!='' or invoice/buyer/contact/text!='' or invoice/buyer/contact/phone!=''"><span class="t10">Er referens</span><br/><xsl:if test="invoice/buyer/contact/name!=invoice/buyer/contact/text"><xsl:value-of select="invoice/buyer/contact/text"/>&#160;</xsl:if><xsl:if test="invoice/buyer/contact/name!=''"><xsl:value-of select="invoice/buyer/contact/name"/>&#160;</xsl:if><xsl:if test="invoice/buyer/contact/phone!=''"><xsl:value-of select="invoice/buyer/contact/phone"/>&#160;</xsl:if></xsl:when></xsl:choose></td></tr></table></td><td width="1" bgcolor="white">&#160;</td></tr><tr bgcolor="white"><td colspan="5">&#160;</td></tr></table></td><td width="20" class="t11" valign="top"/><td width="320" align="left" valign="top"><table width="320" border="0" cellspacing="0" cellpadding="0"><tr bgcolor="white"><td colspan="5">&#160;</td></tr><tr><td width="1" bgcolor="white">&#160;</td><td width="320" valign="top"><table width="320" border="0" cellspacing="2" cellpadding="0"><tr><td width="1" class="t10"><br/><br/><br/><br/><br/><br/><br/></td><td valign="top" class="t12" align="left"><xsl:call-template name="buyerName"/></td><td width="1"/></tr></table></td><td width="1" bgcolor="white">&#160;</td></tr><tr bgcolor="white"><td colspan="5">&#160;</td></tr></table></td></tr></table><table class="rowtable" width="770" border="0" cellspacing="0" cellpadding="0"><tr><td valign="top" class="t12" align="left"><xsl:if test="$countText &lt; 4 or invoice/invoiceDetails/orderReference/@id!='' or invoice/invoiceDetails/projectReference/@id!='' or invoice/invoiceDetails/orderReference/@buyerID!='' or invoice/invoiceDetails/orderReference/date!='' or invoice/delivery/date!='' or invoice/delivery/method!='' or invoice/delivery/terms!='' or invoice/delivery/logistics/wayBillReference/text!='' or invoice/delivery/noteNumber!='' or invoice/delivery/@id!='' or invoice/seller/buyerID!='' or invoice/buyer/@id!='' or invoice/buyer/vatDetails/vatNumber!='' or invoice/invoiceDetails/costCenter!=''"><span class="t9">Meddelande</span><br/></xsl:if><xsl:if test="$countText &lt; 4 and $countText!=0"><xsl:for-each select="invoice/invoiceDetails/text"><xsl:call-template name="breakNote"><xsl:with-param name="text" select="."/></xsl:call-template><br/></xsl:for-each><br/></xsl:if><xsl:if test="invoice/invoiceDetails/invoicePeriod/startDate!=''">Period:&#160;<xsl:value-of select="invoice/invoiceDetails/invoicePeriod/startDate"/>&#160;-&#160;<xsl:value-of select="invoice/invoiceDetails/invoicePeriod/endDate"/><br/></xsl:if><xsl:if test="invoice/invoiceDetails/costCenter!=''">Kostnadsstlle:&#160;<xsl:value-of select="invoice/invoiceDetails/costCenter"/><br/></xsl:if><xsl:if test="invoice/buyer/vatDetails/vatNumber!=''">Ert momsreg.nr:&#160;<xsl:value-of select="invoice/buyer/vatDetails/vatNumber"/><br/></xsl:if><xsl:if test="invoice/buyer/@id!=''">Ert orgnr/personnr:&#160;<xsl:value-of select="invoice/buyer/@id"/><br/></xsl:if><xsl:if test="invoice/seller/buyerID!=''">Leverantrsnr:&#160;<xsl:value-of select="invoice/seller/buyerID"/><br/></xsl:if><xsl:if test="invoice/delivery/@id!=''">Fraktsedelsnr:&#160;<xsl:value-of select="invoice/delivery/@id"/><br/></xsl:if><xsl:if test="invoice/delivery/noteNumber!=''">Fljesedelsnr:&#160;<xsl:value-of select="invoice/delivery/noteNumber"/><br/></xsl:if><xsl:if test="invoice/delivery/logistics/wayBillReference/text!=''">Godsmrke:&#160;<xsl:value-of select="invoice/delivery/logistics/wayBillReference/text"/><br/></xsl:if><xsl:if test="invoice/delivery/terms!=''">Leveransvillkor:&#160;<xsl:value-of select="invoice/delivery/terms"/><br/></xsl:if><xsl:if test="invoice/delivery/method!=''">Leveransstt:&#160;<xsl:value-of select="invoice/delivery/method"/><br/></xsl:if><xsl:if test="invoice/delivery/date!=''">Leveransdatum:&#160;<xsl:value-of select="invoice/delivery/date"/><br/></xsl:if><xsl:if test="invoice/invoiceDetails/orderReference/@id!=''">Vrt ordernr:&#160;<xsl:value-of select="invoice/invoiceDetails/orderReference/@id"/><br/></xsl:if><xsl:if test="invoice/invoiceDetails/orderReference/date!=''">Orderdatum:&#160;<xsl:value-of select="invoice/invoiceDetails/orderReference/date"/><br/></xsl:if><xsl:if test="invoice/invoiceDetails/orderReference/@buyerID!=''">Ert ordernr:&#160;<xsl:value-of select="invoice/invoiceDetails/orderReference/@buyerID"/><br/></xsl:if><xsl:if test="invoice/invoiceDetails/agreementReference/@id!=''">Avtals-/kontraktsnr:&#160;<xsl:value-of select="invoice/invoiceDetails/agreementReference/@id"/><br/></xsl:if><xsl:if test="invoice/invoiceDetails/projectReference/@id!=''">Projektnr:&#160;<xsl:value-of select="invoice/invoiceDetails/projectReference/@id"/><br/></xsl:if><xsl:if test="invoice/invoiceDetails/projectReference/text!=''"><xsl:value-of select="invoice/invoiceDetails/projectReference/text"/></xsl:if><br/><br/></td><td width="1"/></tr></table><table class="detailedTable" width="770" border="0" cellspacing="0" cellpadding="0"><tr><td class="detailedTable" width="460" valign="top" align="left"><xsl:if test="invoice/payment/overDueFine!='' or invoice/payment/overDueFine/@rate!=''"><span class="t9">Drjsmlsrnta/villkor&#160;<br/></span></xsl:if><xsl:choose><xsl:when test="invoice/payment/overDueFine!=''"><span class="t12"><xsl:value-of select="invoice/payment/overDueFine"/></span></xsl:when><xsl:when test="invoice/payment/overDueFine/@rate!=''"><xsl:call-template name="show-rate"><xsl:with-param name="rate" select="invoice/payment/overDueFine/@rate"/></xsl:call-template></xsl:when></xsl:choose></td><td class="detailedTable" width="190" valign="top" align="left"><xsl:if test="invoice/payment/terms!=''"><span class="t9">&#160;Betalningsvillkor&#160;<br/></span></xsl:if><span class="t12"><span class="t9">&#160;</span><xsl:value-of select="invoice/payment/terms"/></span></td><td class="detailedTable" width="90" valign="top" align="left"><span class="t9">&#160;Frfallodatum&#160;<br/>&#160;</span><span class="t12"><xsl:value-of select="invoice/payment/dueDate"/></span></td></tr><tr><td colspan="7"><table width="770" border="0" cellspacing="0" cellpadding="0"><tr><td width="770" valign="top" align="left"><table width="770" border="0" cellspacing="0" cellpadding="0"><xsl:call-template name="invoiceRow"/><tr><td width="3"/><td valign="top" class="t9" align="left" colspan="7"><br/><br/></td><td width="3"/></tr><xsl:for-each select="invoice/invoiceDetails/discountDetails"><xsl:if test="discount/netAmount!='' or discount/amount!='' or discount/@percent!=''"><tr><td width="3"/><xsl:choose><xsl:when test="$countInvoiceRowId &gt; 0 and 'B2C01'!=string(/invoice/printInfo/layout) and 'B2C02'!=string(/invoice/printInfo/layout)"><td valign="top" class="t9" align="left" colspan="6"/></xsl:when><xsl:otherwise><td valign="top" class="t9" align="left" colspan="5"/></xsl:otherwise></xsl:choose><td valign="top" class="t9" align="left" colspan="2"><xsl:choose><xsl:when test="0=string-length(string(discount/text))">Fakturarabatt&#160;<xsl:if test="discount/@percent!=''"><xsl:call-template name="show-rate"><xsl:with-param name="rate" select="discount/@percent"/></xsl:call-template></xsl:if></xsl:when><xsl:otherwise><xsl:value-of select="discount/text"/></xsl:otherwise></xsl:choose></td><td valign="top" class="t9" align="right"><xsl:choose><xsl:when test="discount/amount!=''"><xsl:call-template name="show-discount-amount"><xsl:with-param name="amount" select="discount/amount"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="show-discount-amount"><xsl:with-param name="amount" select="discount/netAmount"/></xsl:call-template></xsl:otherwise></xsl:choose></td><td width="3"/></tr></xsl:if></xsl:for-each><xsl:choose><xsl:when test="/invoice/invoiceDetails/identifier[@type='OCR']!=''"><xsl:for-each select="invoice/invoiceDetails/expenses[0!=string-length(string(totalAmount))]"><tr><td width="3"/><xsl:choose><xsl:when test="'INV03'=string(invoice/@type) or 'B2C01'=string(/invoice/printInfo/layout) or 'B2C02'=string(/invoice/printInfo/layout)"/><xsl:when test="$countInvoiceRowId &gt; 0 and 'B2C01'!=string(/invoice/printInfo/layout) and 'B2C02'!=string(/invoice/printInfo/layout)"><td valign="top" class="t9" align="left" colspan="6"/></xsl:when><xsl:otherwise><td valign="top" class="t9" align="left" colspan="5"/></xsl:otherwise></xsl:choose><td valign="top" class="t10" align="left" colspan="2"><xsl:choose><xsl:when test="0=string-length(string(text))">Avgift</xsl:when><xsl:otherwise><xsl:value-of select="text"/></xsl:otherwise></xsl:choose></td><td valign="top" class="t10" align="right"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="totalAmount"/></xsl:call-template></td><td width="3"/></tr></xsl:for-each></xsl:when><xsl:otherwise><xsl:for-each select="invoice/invoiceDetails/expenses[0!=string-length(string(netAmount))]"><tr><td width="3"/><xsl:choose><xsl:when test="'INV03'=string(invoice/@type) or 'B2C01'=string(/invoice/printInfo/layout) or 'B2C02'=string(/invoice/printInfo/layout)"/><xsl:when test="$countInvoiceRowId &gt; 0 and 'B2C01'!=string(/invoice/printInfo/layout) and 'B2C02'!=string(/invoice/printInfo/layout)"><td valign="top" class="t9" align="left" colspan="6"/></xsl:when><xsl:otherwise><td valign="top" class="t9" align="left" colspan="5"/></xsl:otherwise></xsl:choose><td valign="top" class="t10" align="left" colspan="2"><xsl:choose><xsl:when test="0=string-length(string(text))">Avgift</xsl:when><xsl:otherwise><xsl:value-of select="text"/></xsl:otherwise></xsl:choose></td><td valign="top" class="t10" align="right"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="netAmount"/></xsl:call-template></td><td width="3"/></tr></xsl:for-each></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="0!=string-length(string(/invoice/invoiceDetails/identifier[@type='OCR']))"><xsl:if test="0!=string-length(string(invoice/invoiceDetails/freightDetails/totalAmount))"><tr><td width="3"/><xsl:choose><xsl:when test="'INV03'=string(invoice/@type) or 'B2C01'=string(/invoice/printInfo/layout) or 'B2C02'=string(/invoice/printInfo/layout)"/><xsl:when test="$countInvoiceRowId &gt; 0 and 'B2C01'!=string(/invoice/printInfo/layout) and 'B2C02'!=string(/invoice/printInfo/layout)"><td valign="top" class="t9" align="left" colspan="6"/></xsl:when><xsl:otherwise><td valign="top" class="t9" align="left" colspan="5"/></xsl:otherwise></xsl:choose><td valign="top" class="t10" align="left" colspan="2"><xsl:choose><xsl:when test="0=string-length(string(invoice/invoiceDetails/freightDetails/text))">Frakt</xsl:when><xsl:otherwise><xsl:value-of select="invoice/invoiceDetails/freightDetails/text"/></xsl:otherwise></xsl:choose></td><td valign="top" class="t10" align="right"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="invoice/invoiceDetails/freightDetails/totalAmount"/></xsl:call-template><br/><br/></td><td width="3"/></tr></xsl:if></xsl:when><xsl:otherwise><xsl:if test="invoice/invoiceDetails/freightDetails/freightAmount!=''"><tr><td width="3"/><xsl:choose><xsl:when test="'INV03'=string(invoice/@type) or 'B2C01'=string(/invoice/printInfo/layout) or 'B2C02'=string(/invoice/printInfo/layout)"/><xsl:when test="$countInvoiceRowId &gt; 0 and 'B2C01'!=string(/invoice/printInfo/layout) and 'B2C02'!=string(/invoice/printInfo/layout)"><td valign="top" class="t9" align="left" colspan="6"/></xsl:when><xsl:otherwise><td valign="top" class="t9" align="left" colspan="5"/></xsl:otherwise></xsl:choose><td valign="top" class="t10" align="left" colspan="2"><xsl:choose><xsl:when test="0=string-length(string(invoice/invoiceDetails/freightDetails/text))">Frakt</xsl:when><xsl:otherwise><xsl:value-of select="invoice/invoiceDetails/freightDetails/text"/></xsl:otherwise></xsl:choose></td><td valign="top" class="t10" align="right"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="invoice/invoiceDetails/freightDetails/freightAmount"/></xsl:call-template><br/><br/></td><td width="3"/></tr></xsl:if></xsl:otherwise></xsl:choose><xsl:if test="'INV02'=invoice/@type"><xsl:if test="invoice/invoiceDetails/invoiceReference/totalAmount!=''"><xsl:if test="invoice/invoiceDetails/invoiceReference/vatAmount!=''"><tr><td width="3"/><xsl:choose><xsl:when test="'INV03'=string(invoice/@type) or 'B2C01'=string(/invoice/printInfo/layout) or 'B2C02'=string(/invoice/printInfo/layout)"/><xsl:otherwise><td valign="top" class="t9" align="left" colspan="5"/></xsl:otherwise></xsl:choose><td valign="top" class="t10" align="left" colspan="2">Ursprungsmoms</td><td valign="top" class="t10" align="right"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="invoice/invoiceDetails/invoiceReference/vatAmount"/></xsl:call-template></td><td width="3"/></tr></xsl:if><tr><td width="3"/><xsl:choose><xsl:when test="'INV03'=string(invoice/@type) or 'B2C01'=string(/invoice/printInfo/layout) or 'B2C02'=string(/invoice/printInfo/layout)"/><xsl:otherwise><td valign="top" class="t9" align="left" colspan="5"/></xsl:otherwise></xsl:choose><td valign="top" class="t10" align="left" colspan="2">Ursprungsbelopp</td><td valign="top" class="t10" align="right"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="invoice/invoiceDetails/invoiceReference/totalAmount"/></xsl:call-template><br/><br/></td><td width="3"/></tr></xsl:if></xsl:if><xsl:for-each select="invoice/invoiceDetails/vatAmount"><xsl:if test="0!=string-length(string(node()))"><xsl:if test="0!=string-length(string(@base)) or 0!=string-length(string(@rate))"><xsl:if test="position()=1"><tr><td valign="top" class="t9" align="left" colspan="3">&#160;</td></tr><tr><xsl:choose><xsl:when test="'INV03'=string(invoice/@type) or 'B2C01'=string(/invoice/printInfo/layout) or 'B2C02'=string(/invoice/printInfo/layout)"><td valign="top" class="t9" align="left" colspan="1"/></xsl:when><xsl:when test="$countInvoiceRowId &gt; 0 and 'B2C01'!=string(/invoice/printInfo/layout) and 'B2C02'!=string(/invoice/printInfo/layout)"><td valign="top" class="t9" align="left" colspan="7"/></xsl:when><xsl:when test="'B2B01'=string(/invoice/printInfo/layout) or 'B2B02'=string(/invoice/printInfo/layout) or $countInvoiceRowId &gt; 0 or $countInvoiceRowArticleId &gt; 0"><td valign="top" class="t9" align="left" colspan="6"/></xsl:when><xsl:otherwise><td valign="top" class="t9" align="left" colspan="6"/></xsl:otherwise></xsl:choose><td valign="top" class="t9" align="left">Momssats</td><td valign="top" class="t9" align="right"><xsl:if test="0!=string-length(string(@base))">Netto</xsl:if></td><td valign="top" class="t9" align="right">Moms</td></tr></xsl:if><tr><xsl:choose><xsl:when test="'INV03'=string(invoice/@type) or 'B2C01'=string(/invoice/printInfo/layout) or 'B2C02'=string(/invoice/printInfo/layout)"><td valign="top" class="t9" align="left" colspan="1"/></xsl:when><xsl:when test="$countInvoiceRowId &gt; 0 and 'B2C01'!=string(/invoice/printInfo/layout) and 'B2C02'!=string(/invoice/printInfo/layout)"><td valign="top" class="t9" align="left" colspan="7"/></xsl:when><xsl:when test="'B2B01'=string(/invoice/printInfo/layout) or 'B2B02'=string(/invoice/printInfo/layout) or $countInvoiceRowId &gt; 0 or $countInvoiceRowArticleId &gt; 0"><td valign="top" class="t9" align="left" colspan="6"/></xsl:when><xsl:otherwise><td valign="top" class="t9" align="left" colspan="6"/></xsl:otherwise></xsl:choose><td valign="top" class="t10" align="left"><xsl:if test="./@rate!=''"><xsl:call-template name="show-rate"><xsl:with-param name="rate" select="@rate"/></xsl:call-template></xsl:if></td><td valign="top" class="t10" align="right"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="@base"/></xsl:call-template></td><td valign="top" class="t10" align="right"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="node()"/></xsl:call-template><xsl:if test="./@currency!=/invoice/invoiceDetails/invoiceTotal/totalAmount/@currency">&#160;<xsl:value-of select="./@currency"/></xsl:if></td></tr></xsl:if></xsl:if></xsl:for-each><tr><th>&#160;</th></tr></table></td></tr></table></td></tr><tr><td colspan="7"><table width="770" border="0" cellspacing="3" cellpadding="0"><tr><td valign="top" class="t12" align="left"><xsl:if test="$countText &gt; 3"><xsl:for-each select="invoice/invoiceDetails/text"><xsl:call-template name="breakNote"><xsl:with-param name="text" select="."/></xsl:call-template><br/></xsl:for-each></xsl:if><br/><xsl:for-each select="invoice/factoring/text"><xsl:value-of select="."/><br/></xsl:for-each><br/></td></tr></table></td></tr><tr><td colspan="7" class="detailedTable"><table class="detailedTable" width="100%" border="0" cellspacing="0" cellpadding="0"><tr><td class="detailedTable" width="50" valign="top" align="left"><span class="t9">&#160;Valuta&#160;<br/><span class="t12"><span class="t9">&#160;</span><xsl:call-template name="show-amount"><xsl:with-param name="currency" select="invoice/invoiceDetails/invoiceTotal/totalAmount/@currency"/></xsl:call-template></span></span></td><td class="detailedTable" width="300" valign="top" align="left"><span class="t9">&#160;<xsl:choose><xsl:when test="'INV02'=invoice/@type and invoice/invoiceDetails/invoiceReference/@id!=''"><span class="t10">Krediterar Fakturanummer</span></xsl:when><xsl:otherwise><xsl:choose><xsl:when test="'OCR'=invoice/invoiceDetails/identifier/@type"><span class="t10">Anges vid betalning (OCR)</span></xsl:when><xsl:when test="'INV02'!=invoice/@type"><span class="t10">Anges vid betalning</span></xsl:when></xsl:choose></xsl:otherwise></xsl:choose>&#160;<br/></span><span class="t12"><span class="t9">&#160;</span><xsl:choose><xsl:when test="'INV02'=string(invoice/@type)"><xsl:value-of select="invoice/invoiceDetails/invoiceReference/@id"/></xsl:when><xsl:when test="'INV03'=string(invoice/@type)">*** MAKULERAD ***</xsl:when><xsl:when test="invoice/epiDetails/paymentInstructions/remittanceID!=''"><xsl:value-of select="invoice/epiDetails/paymentInstructions/remittanceID"/></xsl:when><xsl:when test="invoice/invoiceDetails/identifier[@type='OCR']!=''"><xsl:value-of select="invoice/invoiceDetails/identifier[@type='OCR']"/></xsl:when><xsl:when test="invoice/invoiceDetails/identifier[@type='MED']!=''"><xsl:value-of select="invoice/invoiceDetails/identifier[@type='MED']"/></xsl:when><xsl:when test="invoice/epiDetails/paymentInstructions/remittanceID!=''"><xsl:value-of select="invoice/epiDetails/paymentInstructions/remittanceID"/></xsl:when><xsl:otherwise><xsl:value-of select="invoice/invoiceDetails/invoiceNumber"/></xsl:otherwise></xsl:choose></span></td><td class="detailedTable" width="105" valign="top" align="left"><span class="t9"><xsl:if test="invoice/invoiceDetails/invoiceTotal/netAmount!=''">&#160;Summa exkl moms&#160;<br/></xsl:if></span><span class="t12"><span class="t9">&#160;</span><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="invoice/invoiceDetails/invoiceTotal/netAmount"/></xsl:call-template></span></td><td class="detailedTable" width="95" valign="top" align="left"><span class="t9"><xsl:if test="invoice/invoiceDetails/invoiceTotal/vatAmount!=''"><xsl:if test="invoice/invoiceDetails/invoiceTotal/vatAmount/@rate!=''">&#160;<xsl:value-of select="invoice/invoiceDetails/invoiceTotal/vatAmount/@rate"/>%&#160;</xsl:if>&#160;Moms&#160;<br/></xsl:if></span><span class="t12"><span class="t9">&#160;</span><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="invoice/invoiceDetails/invoiceTotal/vatAmount"/></xsl:call-template></span></td><td class="detailedTable" width="50" valign="top" align="left"><span class="t9"><xsl:if test="invoice/invoiceDetails/invoiceTotal/roundingAmount!=''">&#160;resavr.&#160;<br/></xsl:if></span><span class="t12"><span class="t9">&#160;</span><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="invoice/invoiceDetails/invoiceTotal/roundingAmount"/></xsl:call-template></span></td><td class="detailedTable" valign="top" align="right"><span class="t11">&#160;<xsl:choose><xsl:when test="invoice/@type='INV02'"><b>ATT ERHLLA</b>&#160;</xsl:when><xsl:otherwise><b>ATT BETALA</b>&#160;</xsl:otherwise></xsl:choose><br/></span><span class="t12"><span class="t9">&#160;</span><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="invoice/invoiceDetails/invoiceTotal/totalAmount"/></xsl:call-template>&#160;</span></td></tr></table></td></tr><tr><td width="1"/><td colspan="7"/></tr></table><table border="0" cellspacing="0" cellpadding="0" width="770"><tr><td valign="top" class="t9" align="left" width="200"><xsl:call-template name="sellerName"/></td><td valign="top" class="t9" align="left" width="60"><xsl:if test="invoice/seller/mainContact/phone!=''">Telefon<br/></xsl:if><xsl:if test="invoice/seller/mainContact/fax!=''">Fax<br/></xsl:if><xsl:if test="invoice/seller/mainContact/email!=''">E-post<br/></xsl:if><xsl:if test="invoice/seller/mainContact/URL!=''">Hemsida<br/></xsl:if></td><td valign="top" class="t9" align="left" width="100"><xsl:if test="invoice/seller/mainContact/phone!=''"><xsl:value-of select="invoice/seller/mainContact/phone"/><br/></xsl:if><xsl:if test="invoice/seller/mainContact/fax!=''"><xsl:value-of select="invoice/seller/mainContact/fax"/><br/></xsl:if><xsl:if test="invoice/seller/mainContact/email!=''"><xsl:value-of select="invoice/seller/mainContact/email"/><br/></xsl:if><xsl:if test="invoice/seller/mainContact/URL!=''"><xsl:value-of select="invoice/seller/mainContact/URL"/><br/></xsl:if></td><td valign="top" class="t9" align="left" width="90"><xsl:if test="invoice/seller/@id!=''">Organisationsnr<br/></xsl:if><xsl:if test="invoice/seller/vatDetails/vatNumber!=''">Momsreg.nr.<br/></xsl:if><xsl:if test="invoice/seller/vatDetails/homeTown!=''">Fretagets ste<br/></xsl:if><xsl:if test="invoice/seller/bank/name!=''">Bank<br/></xsl:if></td><td valign="top" class="t9" align="left" width="110"><xsl:if test="invoice/seller/@id!=''"><xsl:choose><xsl:when test="10=string-length(string(invoice/seller/@id))"><xsl:value-of select="substring(invoice/seller/@id,1,6)"/>-<xsl:value-of select="substring(invoice/seller/@id,7,4)"/></xsl:when><xsl:otherwise><xsl:value-of select="invoice/seller/@id"/></xsl:otherwise></xsl:choose><br/></xsl:if><xsl:if test="invoice/seller/vatDetails/vatNumber!=''"><xsl:value-of select="invoice/seller/vatDetails/vatNumber"/><br/></xsl:if><xsl:if test="invoice/seller/vatDetails/homeTown!=''"><xsl:value-of select="invoice/seller/vatDetails/homeTown"/><br/></xsl:if><xsl:if test="invoice/seller/bank/name!=''"><xsl:value-of select="invoice/seller/bank/name"/><br/></xsl:if></td><td valign="top" class="t9" align="left" width="50"><xsl:if test="0!=string-length(string(invoice/seller/accounts/account[@type='BG']))">Bankgiro<br/></xsl:if><xsl:if test="invoice/seller/accounts/account[@type='PG']!='' and invoice/seller/accounts/account[@type='PG']!='0' and invoice/seller/accounts/account[@type='PG']!='00'  and invoice/seller/accounts/account[@type='PG']!='0000000000'">Plusgiro<br/></xsl:if><xsl:for-each select="invoice/seller/accounts/account[@type='IBAN']"><xsl:variable name="BICRow" select="position()-1"/><xsl:if test="$BICRow=0"><xsl:if test="./@swift!='' or ./@bic!=''">BIC<br/></xsl:if>IBAN<br/></xsl:if></xsl:for-each></td><td valign="top" class="t9" align="left"><xsl:if test="0!=string-length(string(invoice/seller/accounts/account[@type='BG']))"><xsl:call-template name="show-gironr"><xsl:with-param name="gironr" select="invoice/seller/accounts/account[@type='BG']"/></xsl:call-template><br/></xsl:if><xsl:if test="0!=string-length(string(invoice/seller/accounts/account[@type='PG']))"><xsl:call-template name="show-gironrPG"><xsl:with-param name="gironr" select="invoice/seller/accounts/account[@type='PG']"/></xsl:call-template><br/></xsl:if><xsl:for-each select="invoice/seller/accounts/account[@type='IBAN']"><xsl:variable name="BICRow" select="position()-1"/><xsl:if test="$BICRow=0"><xsl:if test="./@swift!='' or ./@bic!=''"><xsl:choose><xsl:when test="0!=string-length(string(./@swift))"><xsl:value-of select="./@swift"/></xsl:when><xsl:when test="0!=string-length(string(./@bic))"><xsl:value-of select="./@bic"/></xsl:when></xsl:choose><br/></xsl:if></xsl:if></xsl:for-each><xsl:for-each select="invoice/seller/accounts/account[@type='IBAN']"><xsl:variable name="IBANRow" select="position()-1"/><xsl:value-of select="."/><br/></xsl:for-each></td></tr><tr><td/><td colspan="4" valign="top" class="t9" align="left"><xsl:if test="invoice/seller/vatDetails/vatRegistration!=''"><xsl:value-of select="invoice/seller/vatDetails/vatRegistration"/></xsl:if></td></tr></table></xsl:otherwise></xsl:choose><br/><br/><br/><xsl:if test="count(invoice/specification/lineItem[@id!='NOACCOUNTPRESENTATION']) &gt; 0"><span class="t19b">BILAGA</span></xsl:if><xsl:for-each select="invoice/specification/lineItem[@id!='NOACCOUNTPRESENTATION']"><p><xsl:call-template name="lineItem"/></p></xsl:for-each></div></div></body></html></xsl:template><xsl:template match="text"><xsl:value-of select="."/><br/></xsl:template><xsl:template name="invoiceRow"><xsl:variable name="invoiceType" select="invoice/@type"/><xsl:variable name="invoiceB2C" select="'INV03'=string(invoice/@type) or 'B2C01'=string(/invoice/printInfo/layout)  or 'B2C02'=string(/invoice/printInfo/layout)"/><xsl:variable name="Header" select="invoice/invoiceDetails/invoiceType"/><xsl:variable name="HeaderId" select="count(invoice/invoiceRow[@id!=''])"/><xsl:variable name="HeaderArticleId" select="count(invoice/invoiceRow[article/@id!='' and article/@id!='0'])"/><xsl:variable name="HeaderArticleNamn" select="count((invoice/invoiceRow)[article/name!=''])"/><xsl:variable name="HeaderArticleAntal" select="count((invoice/invoiceRow)[quantity!='']) + count((invoice/invoiceRow)[deliveredQuantity!=''])"/><xsl:variable name="HeaderArticlePris" select="count((invoice/invoiceRow)[unitPrice!=''])"/><xsl:variable name="HeaderArticleRabattProcent" select="count((invoice/invoiceRow)[discount/@percent!=''])"/><xsl:variable name="HeaderArticleRabattBelopp" select="count((invoice/invoiceRow)[discount/amount!=''])"/><xsl:variable name="HeaderArticleRabattText" select="count((invoice/invoiceRow)[discount/text!=''])"/><xsl:variable name="HeaderArticleNetto" select="count((invoice/invoiceRow)[netAmount!=''])"/><xsl:variable name="HeaderArticleVat" select="count((invoice/invoiceRow)[vatAmount!=''])"/><xsl:variable name="HeaderArticleTotal" select="count((invoice/invoiceRow)[totalAmount!=''])"/><xsl:for-each select="invoice/invoiceRow"><xsl:variable name="rowPos" select="position()-1"/><xsl:if test="$rowPos=0"><xsl:choose><xsl:when test="$invoiceType='INV01'"><xsl:choose><xsl:when test="$invoiceB2C= false()"><xsl:call-template name="invoice-row-header"><xsl:with-param name="invoiceHeader" select="$Header"/><xsl:with-param name="countHeaderId" select="$HeaderId"/><xsl:with-param name="countHeaderArticleId" select="$HeaderArticleId"/><xsl:with-param name="countHeaderArticleNamn" select="$HeaderArticleNamn"/><xsl:with-param name="countHeaderArticleAntal" select="$HeaderArticleAntal"/><xsl:with-param name="countHeaderArticlePris" select="$HeaderArticlePris"/><xsl:with-param name="countHeaderArticleRabattProcent" select="$HeaderArticleRabattProcent"/><xsl:with-param name="countHeaderArticleRabattBelopp" select="$HeaderArticleRabattBelopp"/><xsl:with-param name="countHeaderArticleRabattText" select="$HeaderArticleRabattText"/><xsl:with-param name="countHeaderArticleNetto" select="$HeaderArticleNetto"/><xsl:with-param name="countHeaderArticleVat" select="$HeaderArticleVat"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="invoiceB2C-row-header"><xsl:with-param name="invoiceHeader" select="$Header"/><xsl:with-param name="countHeaderId" select="$HeaderId"/><xsl:with-param name="countHeaderArticleId" select="$HeaderArticleId"/><xsl:with-param name="countHeaderArticleNamn" select="$HeaderArticleNamn"/><xsl:with-param name="countHeaderArticleAntal" select="$HeaderArticleAntal"/><xsl:with-param name="countHeaderArticlePris" select="$HeaderArticlePris"/><xsl:with-param name="countHeaderArticleRabattProcent" select="$HeaderArticleRabattProcent"/><xsl:with-param name="countHeaderArticleRabattBelopp" select="$HeaderArticleRabattBelopp"/><xsl:with-param name="countHeaderArticleRabattText" select="$HeaderArticleRabattText"/><xsl:with-param name="countHeaderArticleNetto" select="$HeaderArticleNetto"/><xsl:with-param name="countHeaderArticleVat" select="$HeaderArticleVat"/></xsl:call-template></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$invoiceType='INV02'"><xsl:choose><xsl:when test="$invoiceB2C= false()"><xsl:call-template name="invoice-row-header"><xsl:with-param name="invoiceHeader" select="$Header"/><xsl:with-param name="countHeaderId" select="$HeaderId"/><xsl:with-param name="countHeaderArticleId" select="$HeaderArticleId"/><xsl:with-param name="countHeaderArticleNamn" select="$HeaderArticleNamn"/><xsl:with-param name="countHeaderArticleAntal" select="$HeaderArticleAntal"/><xsl:with-param name="countHeaderArticlePris" select="$HeaderArticlePris"/><xsl:with-param name="countHeaderArticleRabattProcent" select="$HeaderArticleRabattProcent"/><xsl:with-param name="countHeaderArticleRabattBelopp" select="$HeaderArticleRabattBelopp"/><xsl:with-param name="countHeaderArticleRabattText" select="$HeaderArticleRabattText"/><xsl:with-param name="countHeaderArticleNetto" select="$HeaderArticleNetto"/><xsl:with-param name="countHeaderArticleVat" select="$HeaderArticleVat"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="invoiceB2C-row-header"><xsl:with-param name="invoiceHeader" select="$Header"/><xsl:with-param name="countHeaderId" select="$HeaderId"/><xsl:with-param name="countHeaderArticleId" select="$HeaderArticleId"/><xsl:with-param name="countHeaderArticleNamn" select="$HeaderArticleNamn"/><xsl:with-param name="countHeaderArticleAntal" select="$HeaderArticleAntal"/><xsl:with-param name="countHeaderArticlePris" select="$HeaderArticlePris"/><xsl:with-param name="countHeaderArticleRabattProcent" select="$HeaderArticleRabattProcent"/><xsl:with-param name="countHeaderArticleRabattBelopp" select="$HeaderArticleRabattBelopp"/><xsl:with-param name="countHeaderArticleRabattText" select="$HeaderArticleRabattText"/><xsl:with-param name="countHeaderArticleNetto" select="$HeaderArticleNetto"/><xsl:with-param name="countHeaderArticleVat" select="$HeaderArticleVat"/></xsl:call-template></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$invoiceType='INV03'"><xsl:call-template name="invoiceB2C-row-header"><xsl:with-param name="invoiceHeader" select="$Header"/><xsl:with-param name="countHeaderId" select="$HeaderId"/><xsl:with-param name="countHeaderArticleId" select="$HeaderArticleId"/><xsl:with-param name="countHeaderArticleNamn" select="$HeaderArticleNamn"/><xsl:with-param name="countHeaderArticleAntal" select="$HeaderArticleAntal"/><xsl:with-param name="countHeaderArticlePris" select="$HeaderArticlePris"/><xsl:with-param name="countHeaderArticleRabattProcent" select="$HeaderArticleRabattProcent"/><xsl:with-param name="countHeaderArticleRabattBelopp" select="$HeaderArticleRabattBelopp"/><xsl:with-param name="countHeaderArticleRabattText" select="$HeaderArticleRabattText"/><xsl:with-param name="countHeaderArticleNetto" select="$HeaderArticleNetto"/><xsl:with-param name="countHeaderArticleVat" select="$HeaderArticleVat"/></xsl:call-template></xsl:when><xsl:when test="$invoiceType='INV04'"><xsl:call-template name="interest-row-header"/></xsl:when><xsl:otherwise><xsl:call-template name="info-row"/></xsl:otherwise></xsl:choose></xsl:if><xsl:choose><xsl:when test="$invoiceType='INV01'"><xsl:choose><xsl:when test="$invoiceB2C= false()"><xsl:call-template name="rowCheckB2B"><xsl:with-param name="invoiceHeader" select="$Header"/><xsl:with-param name="countHeaderId" select="$HeaderId"/><xsl:with-param name="countHeaderArticleId" select="$HeaderArticleId"/><xsl:with-param name="countHeaderArticleNamn" select="$HeaderArticleNamn"/><xsl:with-param name="countHeaderArticleAntal" select="$HeaderArticleAntal"/><xsl:with-param name="countHeaderArticlePris" select="$HeaderArticlePris"/><xsl:with-param name="countHeaderArticleRabattProcent" select="$HeaderArticleRabattProcent"/><xsl:with-param name="countHeaderArticleRabattBelopp" select="$HeaderArticleRabattBelopp"/><xsl:with-param name="countHeaderArticleRabattText" select="$HeaderArticleRabattText"/><xsl:with-param name="countHeaderArticleNetto" select="$HeaderArticleNetto"/><xsl:with-param name="countHeaderArticleVat" select="$HeaderArticleVat"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="invoiceB2C-row"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$invoiceType='INV02'"><xsl:choose><xsl:when test="$invoiceB2C= false()"><xsl:call-template name="rowCheckB2B"><xsl:with-param name="invoiceHeader" select="$Header"/><xsl:with-param name="countHeaderId" select="$HeaderId"/><xsl:with-param name="countHeaderArticleId" select="$HeaderArticleId"/><xsl:with-param name="countHeaderArticleNamn" select="$HeaderArticleNamn"/><xsl:with-param name="countHeaderArticleAntal" select="$HeaderArticleAntal"/><xsl:with-param name="countHeaderArticlePris" select="$HeaderArticlePris"/><xsl:with-param name="countHeaderArticleRabattProcent" select="$HeaderArticleRabattProcent"/><xsl:with-param name="countHeaderArticleRabattBelopp" select="$HeaderArticleRabattBelopp"/><xsl:with-param name="countHeaderArticleRabattText" select="$HeaderArticleRabattText"/><xsl:with-param name="countHeaderArticleNetto" select="$HeaderArticleNetto"/><xsl:with-param name="countHeaderArticleVat" select="$HeaderArticleVat"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="invoiceB2C-row"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$invoiceType='INV03'"><xsl:call-template name="invoiceB2C-row"/></xsl:when><xsl:when test="$invoiceType='INV04'"><xsl:call-template name="interest-row"/></xsl:when><xsl:otherwise><xsl:call-template name="info-row"/></xsl:otherwise></xsl:choose></xsl:for-each></xsl:template><xsl:template name="interest-row-header"><tr><td width="60" valign="top" class="t10" align="left">  Fakturanummer </td><td width="95" valign="top" class="t10" align="left">  Fakt datum</td><td width="95" valign="top" class="t10" align="left">    Frf datum</td><td width="90" valign="top" class="t10" align="left" colspan="2">Bet datum</td><td width="60" valign="top" class="t10" align="right">    Ant dgr</td><td width="60" valign="top" class="t10" align="right">    Rnta</td><td width="80" valign="top" class="t10" align="right">    Fakt belopp</td><td width="90" valign="top" class="t10" align="right">    Rntebelopp</td></tr></xsl:template><xsl:template name="invoice-row-header"><xsl:param name="invoiceHeader"/><xsl:param name="countHeaderId"/><xsl:param name="countHeaderArticleId"/><xsl:param name="countHeaderArticleNamn"/><xsl:param name="countHeaderArticleAntal"/><xsl:param name="countHeaderArticlePris"/><xsl:param name="countHeaderArticleRabattProcent"/><xsl:param name="countHeaderArticleRabattBelopp"/><xsl:param name="countHeaderArticleRabattText"/><xsl:param name="countHeaderArticleNetto"/><xsl:param name="countHeaderArticleVat"/><tr><xsl:if test="$countHeaderId &gt; 0"><td valign="top" class="t10" align="left">Pos&#160;</td></xsl:if><xsl:if test="$countHeaderArticleId &gt; 0"><td width="100" valign="top" class="t9" align="left"><xsl:choose><xsl:when test="contains($invoiceHeader, 'avi')">Objektnr</xsl:when><xsl:when test="contains(invoiceHeader, 'AVI')">Objektnr</xsl:when><xsl:otherwise>Artnr</xsl:otherwise></xsl:choose></td><td width="250" valign="top" class="t9" align="left" colspan="2">   Benmning</td></xsl:if><xsl:if test="$countHeaderArticleId = 0"><td width="350" valign="top" class="t9" align="left" colspan="3">   Benmning</td></xsl:if><td width="47" valign="top" class="t9" align="right"><xsl:if test="$countHeaderArticleAntal &gt; 0">Antal</xsl:if></td><td width="50" valign="top" class="t9" align="left">&#160;<xsl:if test="0!=string-length(string(quantity))"/></td><td width="90" valign="top" class="t9" align="right"><xsl:if test="$countHeaderArticlePris &gt; 0"> -pris</xsl:if></td><td width="70" valign="top" class="t9" align="right"><xsl:if test="$countHeaderArticleRabattProcent &gt; 0 or $countHeaderArticleRabattBelopp &gt; 0 or $countHeaderArticleRabattText &gt; 0"> Rabatt</xsl:if></td><td width="70" valign="top" class="t9" align="right">&#160;<xsl:if test="$countHeaderArticleVat &gt; 0">    Moms</xsl:if></td><td width="110" valign="top" class="t9" align="right" colspan="2">    Total&#160;</td></tr></xsl:template><xsl:template name="invoiceB2C-row-header"><xsl:param name="invoiceHeader"/><xsl:param name="countHeaderId"/><xsl:param name="countHeaderArticleId"/><xsl:param name="countHeaderArticleNamn"/><xsl:param name="countHeaderArticleAntal"/><xsl:param name="countHeaderArticlePris"/><xsl:param name="countHeaderArticleRabattProcent"/><xsl:param name="countHeaderArticleRabattBelopp"/><xsl:param name="countHeaderArticleRabattText"/><xsl:param name="countHeaderArticleNetto"/><xsl:param name="countHeaderArticleVat"/><tr><td width="530" valign="top" class="t9" align="left">  Beskrivning</td><td width="80" valign="top" class="t9" align="right"><xsl:if test="$countHeaderArticleAntal &gt; 0">Antal</xsl:if></td><td width="70" valign="top" class="t9" align="right"><xsl:if test="$countHeaderArticlePris &gt; 0"> -pris</xsl:if></td><td width="90" valign="top" class="t9" align="right">   Total&#160;</td></tr></xsl:template><xsl:template name="info-row-header"><tr><td width="470" valign="top" class="t9" align="left" colspan="7">Benmning</td><td width="80" valign="top" class="t9" align="right">    Moms</td><td width="120" valign="top" class="t9" align="right" colspan="2">    Belopp</td></tr></xsl:template><xsl:template name="rowCheckB2B"><xsl:param name="invoiceHeader"/><xsl:param name="countHeaderId"/><xsl:param name="countHeaderArticleId"/><xsl:param name="countHeaderArticleNamn"/><xsl:param name="countHeaderArticleAntal"/><xsl:param name="countHeaderArticlePris"/><xsl:param name="countHeaderArticleRabattProcent"/><xsl:param name="countHeaderArticleRabattBelopp"/><xsl:param name="countHeaderArticleRabattText"/><xsl:param name="countHeaderArticleNetto"/><xsl:param name="countHeaderArticleVat"/><xsl:choose><xsl:when test="0!=string-length(string($countHeaderArticleNamn))"><xsl:call-template name="article-row"><xsl:with-param name="invoiceHeader" select="$invoiceHeader"/><xsl:with-param name="countHeaderId" select="$countHeaderId"/><xsl:with-param name="countHeaderArticleId" select="$countHeaderArticleId"/><xsl:with-param name="countHeaderArticleNamn" select="$countHeaderArticleNamn"/><xsl:with-param name="countHeaderArticleAntal" select="$countHeaderArticleAntal"/><xsl:with-param name="countHeaderArticlePris" select="$countHeaderArticlePris"/><xsl:with-param name="countHeaderArticleRabattProcent" select="$countHeaderArticleRabattProcent"/><xsl:with-param name="countHeaderArticleRabattBelopp" select="$countHeaderArticleRabattBelopp"/><xsl:with-param name="countHeaderArticleRabattText" select="$countHeaderArticleRabattText"/><xsl:with-param name="countHeaderArticleNetto" select="$countHeaderArticleNetto"/><xsl:with-param name="countHeaderArticleVat" select="$countHeaderArticleVat"/></xsl:call-template></xsl:when><xsl:when test="0!=string-length(string(invoiceRow/text))"><xsl:call-template name="info-row"/></xsl:when><xsl:otherwise><xsl:call-template name="info-row"/></xsl:otherwise></xsl:choose></xsl:template><!-- End -Checking type of Row for B2B--><xsl:template name="interest-row"><tr><td valign="top" class="t10" align="left"><xsl:value-of select="rowInvoiceReference/@id"/>&#160;</td><td valign="top" class="t10" align="left"><xsl:value-of select="rowInvoiceReference/date"/></td><td valign="top" class="t10" align="left"><xsl:value-of select="rowPaymentReference/payment/dueDate"/></td><td valign="top" class="t10" align="left" colspan="2"><xsl:value-of select="rowPaymentReference/payment/date"/></td><td valign="top" class="t10" align="right"><xsl:value-of select="rowPaymentReference/payment/interest/@days"/></td><td valign="top" class="t10" align="right"><xsl:if test="rowPaymentReference/payment/interest/@rate"><xsl:call-template name="show-rate"><xsl:with-param name="rate" select="rowPaymentReference/payment/interest/@rate"/></xsl:call-template></xsl:if></td><td valign="top" class="t10" align="right"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="rowPaymentReference/payment/totalAmount"/></xsl:call-template></td><td valign="top" class="t10" align="right"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="rowPaymentReference/payment/interest/amount"/></xsl:call-template></td></tr></xsl:template><xsl:template name="info-row"><tr><xsl:choose><xsl:when test="0!=string-length(string(netAmount)) or 0!=string-length(string(totalAmount))"><td valign="top" class="t10" align="left"/><td valign="top" class="t10" align="left" colspan="2"><xsl:value-of select="text"/></td><xsl:call-template name="row-suffix"/></xsl:when><xsl:when test="0=string-length(string(./@id)) and 0=string-length(string(netAmount)) and 0=string-length(string(totalAmount))"><td valign="top" class="t10" align="left" colspan="8"><xsl:value-of select="text"/></td><xsl:call-template name="row-suffix"/></xsl:when><xsl:otherwise><td valign="top" class="t10" align="left"/><td valign="top" class="t10" align="left" colspan="7"><xsl:value-of select="text"/></td></xsl:otherwise></xsl:choose></tr></xsl:template><xsl:template name="article-row"><xsl:param name="invoiceHeader"/><xsl:param name="countHeaderId"/><xsl:param name="countHeaderArticleId"/><xsl:param name="countHeaderArticleNamn"/><xsl:param name="countHeaderArticleAntal"/><xsl:param name="countHeaderArticlePris"/><xsl:param name="countHeaderArticleRabattProcent"/><xsl:param name="countHeaderArticleRabattBelopp"/><xsl:param name="countHeaderArticleRabattText"/><xsl:param name="countHeaderArticleNetto"/><xsl:param name="countHeaderArticleVat"/><xsl:if test="$countHeaderArticleId &gt; 0"><tr><xsl:if test="$countHeaderId &gt; 0"><td valign="top" class="t10" align="left"><xsl:value-of select="@id"/>&#160;</td></xsl:if><td valign="top" class="t10" align="left"><xsl:value-of select="article/@id"/></td><xsl:choose><xsl:when test="(netAmount='' or totalAmount='') and quantity='' and deliveredQuantity='' and unitPrice=''"><td valign="top" class="t10" align="left" colspan="7"><xsl:value-of select="article/name"/></td></xsl:when><xsl:otherwise><td valign="top" class="t10" align="left" colspan="2"><xsl:value-of select="article/name"/></td><xsl:call-template name="row-suffix"/></xsl:otherwise></xsl:choose></tr></xsl:if><xsl:choose><xsl:when test="$countHeaderArticleId = 0 and article/name!=''"><tr><xsl:if test="$countHeaderId &gt; 0"><td valign="top" class="t10" align="left"><xsl:value-of select="@id"/>&#160;</td></xsl:if><td valign="top" class="t10" align="left" colspan="3"><xsl:value-of select="article/name"/></td><xsl:call-template name="row-suffix"/></tr></xsl:when><xsl:when test="$countHeaderArticleId = 0"><tr><xsl:if test="$countHeaderId &gt; 0"><td valign="top" class="t10" align="left"><xsl:value-of select="@id"/>&#160;</td></xsl:if><td valign="top" class="t10" align="left" colspan="3"><xsl:for-each select="text"><xsl:value-of select="."/><xsl:if test="0=string-length(string(.))">&#160;</xsl:if></xsl:for-each></td><xsl:call-template name="row-suffix"/></tr></xsl:when></xsl:choose><xsl:if test="0!=string-length(string(article/@alternativeNo)) and article/@id!=article/@alternativeNo"><tr><xsl:if test="$countHeaderId &gt; 0"><td valign="top" class="t10" align="left"/></xsl:if><xsl:if test="$countHeaderArticleId &gt; 0"><td valign="top" class="t10" align="left"/></xsl:if><td colspan="6" valign="top" class="t10" align="left">Alternativt artikelnr:&#160;<xsl:value-of select="article/@alternativeNo"/></td></tr></xsl:if><xsl:if test="0!=string-length(string(article/@buyerID))"><tr><xsl:if test="$countHeaderId &gt; 0"><td valign="top" class="t10" align="left"/></xsl:if><xsl:if test="$countHeaderArticleId &gt; 0"><td valign="top" class="t10" align="left"/></xsl:if><td colspan="6" valign="top" class="t10" align="left">Kparens artikelnr:&#160;<xsl:value-of select="article/@buyerID"/></td></tr></xsl:if><xsl:if test="0!=string-length(string(rowDeliveryReference/date)) or string-length(string(rowDeliveryReference/@id)) > 1 or 0!=string-length(string(rowOrderReference/date)) or 0!=string-length(string(rowOrderReference[@owner='seller' or not(@owner)]/@id)) or 0!=string-length(string(rowOrderReference/@buyerID)) or 0!=string-length(string(rowInvoiceReference/@id)) or 0!=string-length(string(rowInvoiceReference/netAmount)) or 0!=string-length(string(agreementID)) or costCenter!='' or shortProposedAccount!='' or period/startDate!='' or period/endDate!=''"><tr><xsl:if test="$countHeaderId &gt; 0"><td valign="top" class="t10" align="left"/></xsl:if><xsl:if test="$countHeaderArticleId &gt; 0"><td valign="top" class="t10" align="left"/></xsl:if><xsl:choose><xsl:when test="$countHeaderArticleId = 0"><td colspan="8" valign="top" class="t10" align="left"><xsl:call-template name="invoiceB2B-rowExtra"/></td></xsl:when><xsl:otherwise><td colspan="6" valign="top" class="t10" align="left"><xsl:call-template name="invoiceB2B-rowExtra"/></td></xsl:otherwise></xsl:choose></tr></xsl:if><xsl:if test="article/name!=''"><xsl:for-each select="text"><tr><xsl:if test="$countHeaderId &gt; 0"><td valign="top" class="t10" align="left"/></xsl:if><xsl:if test="$countHeaderArticleId &gt; 0"><td valign="top" class="t10" align="left"/></xsl:if><xsl:choose><xsl:when test="$countHeaderArticleId = 0"><td colspan="8" valign="top" class="t10" align="left"><xsl:value-of select="."/><xsl:if test="0=string-length(string(.))">&#160;</xsl:if></td></xsl:when><xsl:otherwise><td colspan="6" valign="top" class="t10" align="left"><xsl:value-of select="."/><xsl:if test="0=string-length(string(.))">&#160;</xsl:if></td></xsl:otherwise></xsl:choose></tr></xsl:for-each></xsl:if></xsl:template><xsl:template name="invoiceB2B-rowExtra"><xsl:if test="period/startDate!='' or period/endDate!=''">Period: <xsl:value-of select="period/startDate"/> - <xsl:value-of select="period/endDate"/><br/></xsl:if><xsl:if test="0!=string-length(string(rowDeliveryReference/date))">Leveransdatum <xsl:value-of select="rowDeliveryReference/date"/><br/></xsl:if><xsl:if test="string-length(string(rowDeliveryReference/@id)) > 1">Leveransnr <xsl:value-of select="rowDeliveryReference/@id"/><br/></xsl:if><xsl:if test="0!=string-length(string(rowOrderReference/date))">Orderdatum <xsl:value-of select="rowOrderReference/date"/><br/></xsl:if><xsl:if test="0!=string-length(string(rowOrderReference[@owner='seller' or not(@owner)]/@id))">Vrt ordernr <xsl:value-of select="rowOrderReference[@owner='seller' or not(@owner)]/@id"/><br/></xsl:if><xsl:choose><xsl:when test="0!=string-length(string(rowOrderReference[@owner='buyer']/@id))">Ert ordernr <xsl:value-of select="rowOrderReference[@owner='buyer']/@id"/><br/></xsl:when><xsl:when test="rowOrderReference/@buyerID!=''">Ert ordernr <xsl:value-of select="rowOrderReference/@buyerID"/><br/></xsl:when></xsl:choose><xsl:if test="rowInvoiceReference/@id!=''">Krediterar Fakturanummer <xsl:value-of select="rowInvoiceReference/@id"/><br/></xsl:if><xsl:if test="rowInvoiceReference/date!=''">Ursprungs Datum <xsl:value-of select="rowInvoiceReference/date"/><br/></xsl:if><xsl:if test="rowInvoiceReference/vatAmount!=''">Ursprungsmoms <xsl:value-of select="rowInvoiceReference/vatAmount"/><br/></xsl:if><xsl:if test="rowInvoiceReference/netAmount!=''">Ursprungsnettobelopp <xsl:value-of select="rowInvoiceReference/netAmount"/><br/></xsl:if><xsl:if test="agreementID!=''">Avtalsreferens <xsl:value-of select="agreementID"/><br/></xsl:if><xsl:if test="costCenter!=''"><xsl:value-of select="costCenter"/><br/></xsl:if><xsl:if test="shortProposedAccount!=''">Konteringsunderlag:&#160;<xsl:value-of select="shortProposedAccount"/><br/></xsl:if></xsl:template><xsl:template name="row-suffix"><xsl:choose><xsl:when test="quantity!='' or deliveredQuantity!=''"><td valign="top" class="t10" align="right"><xsl:choose><xsl:when test="quantity='' and deliveredQuantity!=''"><xsl:call-template name="show-quantity"><xsl:with-param name="quantity" select="deliveredQuantity"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="show-quantity"><xsl:with-param name="quantity" select="quantity"/></xsl:call-template></xsl:otherwise></xsl:choose></td><td valign="top" class="t10" align="left">&#160;<xsl:choose><xsl:when test="0!=string-length(string(article/unit))"><xsl:call-template name="unitReplace"><xsl:with-param name="text" select="article/unit"/></xsl:call-template></xsl:when><xsl:when test="0!=string-length(string(article/unit/@code))"><xsl:call-template name="unitReplace"><xsl:with-param name="text" select="article/unit/@code"/></xsl:call-template></xsl:when><xsl:when test="0!=string-length(string(quantity/@unitCode))"><xsl:call-template name="unitReplace"><xsl:with-param name="text" select="quantity/@unitCode"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="unitReplace"><xsl:with-param name="text" select="article/unit"/></xsl:call-template></xsl:otherwise></xsl:choose></td></xsl:when><xsl:otherwise><td valign="top" class="t10" align="left" colspan="2"/></xsl:otherwise></xsl:choose><td valign="top" class="t10" align="right"><xsl:if test="unitPrice"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="unitPrice"/></xsl:call-template><xsl:choose><xsl:when test="0!=string-length(string(unitPrice/@unit))">&#160;<xsl:call-template name="unitReplace"><xsl:with-param name="text" select="unitPrice/@unit"/></xsl:call-template></xsl:when></xsl:choose></xsl:if></td><td valign="top" class="t10" align="right"><xsl:choose><xsl:when test="0!=string-length(string(discount/@percent))"><xsl:call-template name="show-rate"><xsl:with-param name="rate" select="discount/@percent"/></xsl:call-template></xsl:when><xsl:when test="discount/text!='' and discount/amount=''"><xsl:value-of select="discount/text"/></xsl:when><xsl:otherwise><xsl:if test="discount/amount"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="discount/amount"/></xsl:call-template></xsl:if></xsl:otherwise></xsl:choose></td><td valign="top" class="t10" align="right"><xsl:if test="vatAmount"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="vatAmount"/></xsl:call-template></xsl:if></td><td valign="top" class="t10" align="right"><xsl:if test="netAmount"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="netAmount"/></xsl:call-template></xsl:if></td></xsl:template><!-- Article row - B2C --><xsl:template name="invoiceB2C-row"><tr><xsl:call-template name="article-row-suffix"/><xsl:call-template name="quantity-row-suffix"/><xsl:call-template name="unitPrice-row-suffix"/><xsl:call-template name="totalAmount-row-suffix"/></tr><tr><td colspan="6" valign="top" class="t10" align="left"><xsl:for-each select="text"><xsl:if test="0!=string-length(string(.))"><xsl:value-of select="."/><br/></xsl:if></xsl:for-each></td></tr></xsl:template><xsl:template name="article-row-suffix"><td valign="top" class="t10" align="left"><xsl:if test="0!=string-length(string(article/@id))"><xsl:value-of select="article/@id"/>&#160;</xsl:if><xsl:if test="0!=string-length(string(article/name))"><xsl:value-of select="article/name"/><br/></xsl:if></td></xsl:template><xsl:template name="quantity-row-suffix"><td valign="top" class="t10" align="right"><xsl:if test="0!=string-length(string(quantity))"><xsl:call-template name="show-quantity"><xsl:with-param name="quantity" select="quantity"/></xsl:call-template>&#160;<xsl:choose><xsl:when test="0!=string-length(string(article/unit))"><xsl:call-template name="unitReplace"><xsl:with-param name="text" select="article/unit"/></xsl:call-template></xsl:when><xsl:when test="0!=string-length(string(article/unit/@code))"><xsl:value-of select="article/unit/@code"/><xsl:call-template name="unitReplace"><xsl:with-param name="text" select="article/unit"/></xsl:call-template></xsl:when><xsl:when test="0!=string-length(string(quantity/@unitCode))"><xsl:call-template name="unitReplace"><xsl:with-param name="text" select="quantity/@unitCode"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="unitReplace"><xsl:with-param name="text" select="article/unit"/></xsl:call-template></xsl:otherwise></xsl:choose></xsl:if></td></xsl:template><xsl:template name="unitPrice-row-suffix"><td valign="top" class="t10" align="right"><xsl:if test="0!=string-length(string(unitPrice))"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="unitPrice"/></xsl:call-template></xsl:if></td></xsl:template><!-- vatAmount--><xsl:template name="vatAmount-row-suffix"><td valign="top" class="t10" align="right"><xsl:if test="0!=string-length(string(vatAmount))"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="vatAmount"/></xsl:call-template></xsl:if></td></xsl:template><xsl:template name="netAmount-row-suffix"><td valign="top" class="t10" align="right"><xsl:if test="0!=string-length(string(netAmount))"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="netAmount"/></xsl:call-template></xsl:if></td></xsl:template><xsl:template name="totalAmount-row-suffix"><td valign="top" class="t10" align="right"><xsl:if test="0!=string-length(string(totalAmount))"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="totalAmount"/></xsl:call-template></xsl:if><xsl:if test="0!=string-length(string(netAmount)) and 0=string-length(string(totalAmount))"><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="netAmount"/></xsl:call-template></xsl:if></td></xsl:template><xsl:template name="show-amount"><xsl:param name="amount"/><xsl:param name="currency"/><xsl:choose><xsl:when test="contains($amount, '-')"><xsl:value-of select='translate(translate(format-number($amount, "###,##0.00"), ",", "&#160;"), ".", ",")'/></xsl:when><xsl:when test="0=string-length($amount)"/><xsl:otherwise><xsl:value-of select='translate(translate(format-number($amount, "###,##0.00"), ",", "&#160;"), ".", ",")'/></xsl:otherwise></xsl:choose><xsl:if test="$currency"><xsl:value-of select="$currency"/></xsl:if></xsl:template><xsl:template name="show-discount-amount"><xsl:param name="amount"/><xsl:param name="currency"/><xsl:if test="$amount &gt; 0">-</xsl:if><xsl:call-template name="show-amount"><xsl:with-param name="amount" select="$amount"/><xsl:with-param name="currency" select="$currency"/></xsl:call-template></xsl:template><xsl:template name="show-rate"><xsl:param name="rate"/><xsl:choose><xsl:when test="contains($rate, '-')"><xsl:value-of select="translate($rate, '.', ',' ) "/>%</xsl:when><xsl:otherwise><xsl:value-of select="translate($rate, '.', ',' ) "/>%</xsl:otherwise></xsl:choose></xsl:template><xsl:template name="show-quantity"><xsl:param name="quantity"/><xsl:choose><xsl:when test="contains($quantity, '-')"><xsl:value-of select="translate($quantity, '.', ',' ) "/></xsl:when><xsl:otherwise><xsl:value-of select="translate($quantity, '.', ',' ) "/></xsl:otherwise></xsl:choose></xsl:template><xsl:template name="show-gironr"><xsl:param name="gironr"/><xsl:choose><xsl:when test="contains($gironr, '-')"><xsl:value-of select="$gironr"/></xsl:when><xsl:when test="0=string-length($gironr)"/><xsl:otherwise><xsl:value-of select='translate(format-number($gironr, "####,###0"), ",", "-")'/></xsl:otherwise></xsl:choose></xsl:template><xsl:template name="show-gironrNumber"><xsl:param name="gironr"/><xsl:choose><xsl:when test="contains($gironr, '-')"><xsl:value-of select='translate(format-number($gironr, "####,###0"), ",", "-")'/></xsl:when><xsl:when test="0=string-length($gironr)"/><xsl:otherwise><xsl:value-of select="$gironr"/></xsl:otherwise></xsl:choose></xsl:template><xsl:template name="show-gironrPG"><xsl:param name="gironr"/><xsl:choose><xsl:when test="contains($gironr, '-')"><xsl:value-of select="$gironr"/></xsl:when><xsl:when test="0=string-length($gironr) or $gironr='0000000000' or $gironr='0' or $gironr='00'"/><xsl:otherwise><xsl:if test="2=string-length(string($gironr))"><xsl:value-of select='format-number(number(substring($gironr,1,1)), "##########")'/>-<xsl:value-of select='format-number(number(substring($gironr,2,1)), "#########0")'/></xsl:if><xsl:if test="3=string-length(string($gironr))"><xsl:value-of select='format-number(number(substring($gironr,1,2)), "##########")'/>-<xsl:value-of select='format-number(number(substring($gironr,3,1)), "#########0")'/></xsl:if><xsl:if test="4=string-length(string($gironr))"><xsl:value-of select='format-number(number(substring($gironr,1,3)), "##########")'/>-<xsl:value-of select='format-number(number(substring($gironr,4,1)), "#########0")'/></xsl:if><xsl:if test="5=string-length(string($gironr))"><xsl:value-of select='format-number(number(substring($gironr,1,4)), "##########")'/>-<xsl:value-of select='format-number(number(substring($gironr,5,1)), "#########0")'/></xsl:if><xsl:if test="6=string-length(string($gironr))"><xsl:value-of select='format-number(number(substring($gironr,1,5)), "##########")'/>-<xsl:value-of select='format-number(number(substring($gironr,6,1)), "#########0")'/></xsl:if><xsl:if test="7=string-length(string($gironr))"><xsl:value-of select='format-number(number(substring($gironr,1,6)), "##########")'/>-<xsl:value-of select='format-number(number(substring($gironr,7,1)), "#########0")'/></xsl:if><xsl:if test="8=string-length(string($gironr))"><xsl:value-of select='format-number(number(substring($gironr,1,7)), "##########")'/>-<xsl:value-of select='format-number(number(substring($gironr,8,1)), "#########0")'/></xsl:if><xsl:if test="9=string-length(string($gironr))"><xsl:value-of select='format-number(number(substring($gironr,1,8)), "##########")'/>-<xsl:value-of select='format-number(number(substring($gironr,9,1)), "#########0")'/></xsl:if><xsl:if test="10=string-length(string($gironr))"><xsl:value-of select='format-number(number(substring($gironr,1,9)), "##########")'/>-<xsl:value-of select='format-number(number(substring($gironr,10,1)), "#########0")'/></xsl:if></xsl:otherwise></xsl:choose></xsl:template><xsl:template name="breakNote"><xsl:param name="text"/><xsl:choose><xsl:when test="contains($text, '&#10;')"><xsl:value-of select="substring-before($text, '&#10;')"/><br/><xsl:call-template name="breakNote"><xsl:with-param name="text" select="substring-after($text,'&#10;')"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:value-of select="$text"/></xsl:otherwise></xsl:choose></xsl:template><xsl:template name="lineItem"><pre><xsl:for-each select="desc"><xsl:choose><xsl:when test="substring(@spec,1,1)='B'"><b><xsl:value-of select="."/><br/></b></xsl:when><xsl:otherwise><xsl:value-of select="."/><br/></xsl:otherwise></xsl:choose></xsl:for-each></pre></xsl:template><xsl:template name="imageTop"><xsl:choose><xsl:when test="0!=string-length(invoice/printInfo/imageBase64/URL)"><img border="0" style="margin-left: 10px; margin-top: 20px;" id="image" src="{invoice/printInfo/imageBase64/URL}"/></xsl:when><xsl:when test="0!=string-length(invoice/invoiceDetails/images/@url)"><img border="0" style="margin-left: 10px; margin-top: 20px;" id="image" src="{invoice/invoiceDetails/images/@url}"/></xsl:when><xsl:otherwise><xsl:value-of select="invoice/seller/name"/></xsl:otherwise></xsl:choose></xsl:template><xsl:template name="break"><xsl:param name="text" select="."/><xsl:choose><xsl:when test="contains($text, '&#xa;')"><xsl:value-of select="normalize-space(translate(substring-before($text, '&#xa;'), '&#xA0;',''))"/><br/><xsl:call-template name="break"><xsl:with-param name="text" select="normalize-space(translate(substring-after($text,'&#xa;'), '&#xA0;',''))"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:value-of select="$text"/></xsl:otherwise></xsl:choose></xsl:template><xsl:template name="unitReplace"><xsl:param name="text" select="."/><xsl:choose><xsl:when test="contains($text, 'PCE')">st</xsl:when><xsl:when test="contains($text, 'MMT')">mm</xsl:when><xsl:when test="contains($text, 'CMT')">cm</xsl:when><xsl:when test="contains($text, 'DMT')">dm</xsl:when><xsl:when test="contains($text, 'MTR')">m</xsl:when><xsl:when test="contains($text, 'HMT')">hm</xsl:when><xsl:when test="contains($text, 'KMT')">km</xsl:when><xsl:when test="contains($text, 'GRM')">g</xsl:when><xsl:when test="contains($text, 'HGM')">hg</xsl:when><xsl:when test="contains($text, 'KGM')">kg</xsl:when><xsl:when test="contains($text, 'TNE')">ton</xsl:when><xsl:when test="contains($text, 'KTN')">kton</xsl:when><xsl:when test="contains($text, 'JOU')">J</xsl:when><xsl:when test="contains($text, 'KJO')">KJ</xsl:when><xsl:when test="contains($text, 'SEC')">sek</xsl:when><xsl:when test="contains($text, 'MIN')">min</xsl:when><xsl:when test="contains($text, 'KGM')">kg</xsl:when><xsl:when test="contains($text, 'HUR')">tim</xsl:when><xsl:when test="contains($text, 'WHR')">watt</xsl:when><xsl:when test="contains($text, 'KWH')">kwh</xsl:when><xsl:when test="contains($text, 'KGM')">kg</xsl:when><xsl:otherwise><xsl:value-of select="$text"/></xsl:otherwise></xsl:choose></xsl:template><xsl:template name="buyerName"><xsl:if test="invoice/buyer/recipient/postalAddress/name!='' and invoice/buyer/recipient/postalAddress/street!=invoice/buyer/postalAddress/street"><br/><b>Fakturamottagare</b><br/><xsl:choose><xsl:when test="invoice/buyer/recipient/name=''"><xsl:call-template name="break"><xsl:with-param name="text" select="invoice/buyer/recipient/postalAddress/name"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="break"><xsl:with-param name="text" select="invoice/buyer/recipient/name"/></xsl:call-template></xsl:otherwise></xsl:choose><br/><xsl:if test="invoice/buyer/recipient/postalAddress/reference!=''"><xsl:value-of select="invoice/buyer/recipient/postalAddress/reference"/><br/></xsl:if><xsl:for-each select="invoice/buyer/recipient/postalAddress/street"><xsl:value-of select="."/>&#160;<xsl:value-of select="./@number"/><br/></xsl:for-each><xsl:if test="invoice/buyer/recipient/postalAddress/country/@code!=''"><xsl:value-of select="invoice/buyer/recipient/postalAddress/country/@code"/>-<xsl:value-of select="invoice/buyer/recipient/postalAddress/town/@postCode"/>&#160;<xsl:value-of select="invoice/buyer/recipient/postalAddress/town"/></xsl:if><xsl:if test="0=string-length(string(invoice/buyer/recipient/postalAddress/country/@code))"><xsl:value-of select="invoice/buyer/recipient/postalAddress/town/@postCode"/>&#160;<xsl:value-of select="invoice/buyer/recipient/postalAddress/town"/></xsl:if><br/><xsl:value-of select="invoice/buyer/recipient/postalAddress/country"/><br/><br/><b>Kpare</b></xsl:if><br/><xsl:choose><xsl:when test="0=string-length(invoice/buyer/postalAddress/name)"><xsl:call-template name="break"><xsl:with-param name="text" select="invoice/buyer/postalAddress/name"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="break"><xsl:with-param name="text" select="invoice/buyer/name"/></xsl:call-template></xsl:otherwise></xsl:choose><br/><xsl:if test="invoice/buyer/postalAddress/reference!=''"><xsl:value-of select="invoice/buyer/postalAddress/reference"/><br/></xsl:if><xsl:for-each select="invoice/buyer/postalAddress/street"><xsl:value-of select="."/>&#160;<xsl:value-of select="./@number"/><br/></xsl:for-each><xsl:if test="invoice/buyer/postalAddress/country/@code!=''"><xsl:value-of select="invoice/buyer/postalAddress/country/@code"/>-<xsl:value-of select="invoice/buyer/postalAddress/town/@postCode"/>&#160;<xsl:value-of select="invoice/buyer/postalAddress/town"/></xsl:if><xsl:if test="0=string-length(string(invoice/buyer/postalAddress/country/@code))"><xsl:value-of select="invoice/buyer/postalAddress/town/@postCode"/>&#160;<xsl:value-of select="invoice/buyer/postalAddress/town"/></xsl:if><xsl:if test="invoice/buyer/postalAddress/country!='' and invoice/buyer/postalAddress/country/@code!='SE'"><br/><xsl:value-of select="invoice/buyer/postalAddress/country"/></xsl:if></xsl:template><xsl:template name="sellerName"><xsl:value-of select="invoice/seller/name"/><xsl:if test="invoice/seller/postalAddress/reference!=''"><br/><xsl:value-of select="invoice/seller/postalAddress/reference"/></xsl:if><br/><xsl:for-each select="invoice/seller/postalAddress/street"><xsl:value-of select="."/>&#160;<xsl:value-of select="./@number"/><br/></xsl:for-each><xsl:if test="invoice/seller/postalAddress/country/@code!=''"><xsl:value-of select="invoice/seller/postalAddress/country/@code"/>-<xsl:value-of select="invoice/seller/postalAddress/town/@postCode"/>&#160;<xsl:value-of select="invoice/seller/postalAddress/town"/></xsl:if><xsl:if test="0=string-length(string(invoice/seller/postalAddress/country/@code))"><xsl:value-of select="invoice/seller/postalAddress/town/@postCode"/>&#160;<xsl:value-of select="invoice/seller/postalAddress/town"/></xsl:if><br/><xsl:value-of select="invoice/seller/postalAddress/country"/>
</xsl:template></xsl:stylesheet>
